/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.mbean;

import java.util.ArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.ow2.carol.util.configuration.ConfigurationException;
import org.ow2.carol.util.configuration.ProtocolConfigurationImplMBean;
import org.ow2.carol.util.configuration.ServerConfigurationImplMBean;

public class MBeanUtils {
    private static MBeanServer mbeanServer = null;

    private MBeanUtils() {
    }

    protected static void initMBeanServer(Log logger, String agentId) throws ConfigurationException {
        ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(agentId);
        if (mbeanServers.size() == 0) {
            throw new ConfigurationException("No MBean Servers were found.");
        }
        if (mbeanServers.size() > 1 && logger.isDebugEnabled()) {
            logger.debug((Object)"Take first MBeanServer of the list");
        }
        mbeanServer = (MBeanServer)mbeanServers.get(0);
    }

    public static void registerServerConfigurationMBean(ServerConfigurationImplMBean serverConfiguration, Log logger, String domainName, String serverName, String agentId) throws ConfigurationException {
        if (mbeanServer == null) {
            MBeanUtils.initMBeanServer(logger, agentId);
        }
        StringBuffer sb = new StringBuffer(domainName);
        sb.append(":type=carol");
        sb.append(",name=serverConfiguration");
        sb.append(",J2EEServer=");
        sb.append(serverName);
        ObjectName on = null;
        try {
            on = new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new ConfigurationException("Cannot build ObjectName for the server configuration", e);
        }
        serverConfiguration.setObjectName(on.toString());
        try {
            mbeanServer.unregisterMBean(on);
        }
        catch (InstanceNotFoundException e) {
            logger.debug((Object)"No MBean was registered before", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.debug((Object)"No MBean was registered before", (Throwable)e);
        }
        try {
            mbeanServer.registerMBean(serverConfiguration, on);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot register MBean '" + on + "' in MBeanServer", e);
        }
    }

    public static void registerProtocolConfigurationMBean(ProtocolConfigurationImplMBean protocolConfiguration, Log logger, String domainName, String serverName, String agentId) throws ConfigurationException {
        if (mbeanServer == null) {
            MBeanUtils.initMBeanServer(logger, agentId);
        }
        StringBuffer sb = new StringBuffer(domainName);
        sb.append(":j2eeType=JNDIResource");
        sb.append(",name=");
        sb.append(protocolConfiguration.getName());
        sb.append(",J2EEServer=");
        sb.append(serverName);
        ObjectName on = null;
        try {
            on = new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new ConfigurationException("Cannot build ObjectName for configuration '" + protocolConfiguration.getName() + "'", e);
        }
        protocolConfiguration.setobjectName(on.toString());
        try {
            mbeanServer.unregisterMBean(on);
        }
        catch (InstanceNotFoundException e) {
            logger.debug((Object)"No MBean was registered before", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.debug((Object)"No MBean was registered before", (Throwable)e);
        }
        try {
            mbeanServer.registerMBean(protocolConfiguration, on);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot register MBean '" + on + "' in MBeanServer", e);
        }
    }
}

