/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.faq.service.DataStorage;
import org.exoplatform.faq.service.FAQEventQuery;
import org.exoplatform.faq.service.ObjectSearchResult;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.service.impl.JCRDataStorage;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.UserHelper;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.security.ConversationState;

public class AnswerSearchConnector
extends SearchServiceConnector {
    public static final String SPACES_GROUP = "spaces";
    private static final String ANSWER_PORTLET_NAME = "AnswerPortlet";
    private static final String ANSWER_PAGE_NAGVIGATION = "answers";
    private JCRDataStorage storage;
    private LocaleConfigService localeConfigService;
    private String FIX_ICON = "/answer/skin/DefaultSkin/webui/skinIcons/48x48/defaultQuestion.png";
    private static final Log LOG = ExoLogger.getLogger(AnswerSearchConnector.class);

    public AnswerSearchConnector(InitParams initParams, DataStorage dataStorage, LocaleConfigService localeConfigService) throws Exception {
        super(initParams);
        this.storage = (JCRDataStorage)dataStorage;
        this.localeConfigService = localeConfigService;
    }

    public AnswerSearchConnector(InitParams initParams, DataStorage dataStorage) throws Exception {
        this(initParams, dataStorage, null);
    }

    public Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        String siteName = sites == null || sites.isEmpty() ? "" : sites.iterator().next();
        ExoContainerContext eXoContext = (ExoContainerContext)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ExoContainerContext.class);
        String portalName = eXoContext.getPortalContainerName();
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        FAQEventQuery eventQuery = new FAQEventQuery();
        eventQuery.setType("faqQuestion");
        eventQuery.setAdmin(false);
        eventQuery.setComment(query);
        eventQuery.setQuestion(query);
        eventQuery.setResponse(query);
        eventQuery.setUserId(this.getCurrentUserName());
        eventQuery.setUserMembers(UserHelper.getAllGroupAndMembershipOfUser(null));
        eventQuery.setLanguageLevelSearch(false);
        String language = "English";
        if (this.localeConfigService != null) {
            language = this.localeConfigService.getDefaultLocaleConfig().getLocale().getDisplayLanguage();
        }
        eventQuery.setLanguage(language);
        eventQuery.setSearchOnDefaultLanguage(true);
        eventQuery.setOffset(offset);
        eventQuery.setLimit(limit);
        eventQuery.setSort(sort);
        eventQuery.setOrder(order);
        try {
            List<ObjectSearchResult> searchResults = this.storage.getUnifiedSearchResults(eventQuery);
            for (ObjectSearchResult searchResult : searchResults) {
                StringBuilder sb = new StringBuilder();
                sb.append(searchResult.getName());
                sb.append(" - ").append(searchResult.getNumberOfAnswer()).append(" answers");
                sb.append(" - ").append(searchResult.getNumberOfComment()).append(" comments");
                sb.append(" - ").append(searchResult.getRatingOfQuestion());
                sb.append(" - ").append(searchResult.getCreatedDate());
                String url = this.buildLink(context, portalName, searchResult.getPath(), siteName, searchResult.getLink());
                SearchResult result = new SearchResult(url, searchResult.getName(), searchResult.getDescription(), sb.toString(), this.FIX_ICON, searchResult.getCreatedDate().getTime(), 0L);
                results.add(result);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return results;
    }

    private String buildLink(SearchContext context, String portalName, String questionPath, String siteName, String defaultLink) {
        try {
            String answersURI = "#";
            String categoryId = this.getCategoryId(questionPath);
            String questionId = questionPath.substring(questionPath.indexOf(Question.QUESTION_ID));
            answersURI = categoryId.indexOf(Utils.CATE_SPACE_ID_PREFIX) == 0 ? this.makeURIForSpaceContext(context, portalName, categoryId) : this.makeURIForPortalContext(context, portalName, categoryId, siteName);
            if (CommonUtils.isEmpty((String)answersURI)) {
                return defaultLink;
            }
            answersURI = String.format("%s/%s%s", answersURI, Utils.QUESTION_ID, questionId);
            return answersURI;
        }
        catch (Exception ex) {
            return "#";
        }
    }

    private String makeURIForPortalContext(SearchContext context, String portalName, String categoryId, String siteName) throws Exception {
        String path = "";
        String siteType = "";
        UserPortalConfig prc = this.getUserPortalConfig();
        siteName = CommonUtils.isEmpty((String)siteName) ? prc.getPortalConfig().getName() : siteName;
        SiteKey siteKey = SiteKey.portal((String)siteName);
        siteType = SiteType.PORTAL.getName();
        path = this.getSiteName(siteKey);
        if (CommonUtils.isEmpty((String)path)) {
            return CommonUtils.EMPTY_STR;
        }
        String forumURI = context.handler(portalName).lang("").siteName(siteName).siteType(siteType).path(path).renderLink();
        return String.format("/%s%s", portalName, forumURI);
    }

    private String makeURIForSpaceContext(SearchContext context, String portalName, String categoryId) throws Exception {
        String groupId = categoryId.replace(Utils.CATE_SPACE_ID_PREFIX, CommonUtils.EMPTY_STR);
        String spaceGroupId = String.format("%s/%s", SPACES_GROUP, groupId);
        SiteKey siteKey = SiteKey.group((String)spaceGroupId);
        String siteName = spaceGroupId.replaceAll("/", ":");
        String siteType = SiteType.GROUP.getName();
        String forumNavName = this.getSiteName(siteKey);
        if (CommonUtils.isEmpty((String)forumNavName)) {
            return CommonUtils.EMPTY_STR;
        }
        String path = groupId + "/" + forumNavName;
        String forumURI = context.handler(portalName).lang("").siteName(siteName).siteType(siteType).path(path).renderLink();
        return String.format("/%s%s", portalName, forumURI);
    }

    private String getCategoryId(String questionPath) {
        String categoryId = "categories";
        int i = questionPath.indexOf("Category");
        if (i > 0) {
            categoryId = questionPath.substring(i, questionPath.indexOf("/", i));
        }
        return categoryId;
    }

    private UserPortalConfig getUserPortalConfig() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UserPortalConfigService userPortalConfigSer = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        UserPortalContext NULL_CONTEXT = new UserPortalContext(){

            public ResourceBundle getBundle(UserNavigation navigation) {
                return null;
            }

            public Locale getUserLocale() {
                return Locale.ENGLISH;
            }
        };
        String remoteId = this.getCurrentUserName();
        UserPortalConfig userPortalCfg = userPortalConfigSer.getUserPortalConfig(userPortalConfigSer.getDefaultPortal(), remoteId, NULL_CONTEXT);
        return userPortalCfg;
    }

    private String getSiteName(SiteKey siteKey) {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
            NavigationContext nav = navService.loadNavigation(siteKey);
            NodeContext parentNodeCtx = navService.loadNode(NodeModel.SELF_MODEL, nav, Scope.ALL, null);
            Collection children = parentNodeCtx.getNodes();
            if (siteKey.getType() == SiteType.GROUP) {
                children = ((NodeContext)parentNodeCtx.get(0)).getNodes();
            }
            Iterator it = children.iterator();
            NodeContext child = null;
            while (it.hasNext()) {
                child = (NodeContext)it.next();
                if (!ANSWER_PAGE_NAGVIGATION.equals(child.getName()) && child.getName().indexOf(ANSWER_PORTLET_NAME) < 0) continue;
                return child.getName();
            }
            return CommonUtils.EMPTY_STR;
        }
        catch (Exception e) {
            return CommonUtils.EMPTY_STR;
        }
    }

    private String getCurrentUserName() {
        return ConversationState.getCurrent().getIdentity().getUserId();
    }
}

