/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.webui.popup;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.answer.webui.BaseUIFAQForm;
import org.exoplatform.answer.webui.FAQUtils;
import org.exoplatform.answer.webui.UIAnswersPageIterator;
import org.exoplatform.answer.webui.popup.UIQuestionsInfo;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Cate;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/answer/webui/popup/UIQuestionsInfo.gtmpl", events={@EventConfig(listeners={ChangeCategoryActionListener.class}), @EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={EditQuestionActionListener.class}), @EventConfig(listeners={DeleteQuestionActionListener.class}), @EventConfig(listeners={ChangeTabActionListener.class}), @EventConfig(listeners={ChangeQuestionStatusActionListener.class}), @EventConfig(listeners={ResponseQuestionActionListener.class})})
public class UIQuestionsInfo
extends BaseUIFAQForm
implements UIPopupComponent {
    private static final String LIST_QUESTION_INTERATOR = "FAQUserPageIteratorTab1";
    private static final String LIST_QUESTION_NOT_ANSWERED_INTERATOR = "FAQUserPageIteratorTab2";
    private static final String LIST_CATEGORIES = "ListCategories";
    private FAQSetting faqSetting_ = new FAQSetting();
    private JCRPageList pageList;
    private JCRPageList pageListNotAnswer;
    private UIAnswersPageIterator pageIterator;
    private UIAnswersPageIterator pageQuesNotAnswerIterator;
    private List<Question> listQuestion_ = new ArrayList();
    private List<Question> listQuestionNotYetAnswered_ = new ArrayList();
    private List<SelectItemOption<String>> listCategories = new ArrayList();
    private long pageSelect = 1L;
    private long pageSelectNotAnswer = 1L;
    private List<String> moderateCates = new ArrayList();
    private boolean isEditTab_ = true;
    private boolean isResponseTab_ = false;
    private boolean isChangeTab_ = false;
    private String cateId_ = Utils.ALL;

    public void activate() {
    }

    public void deActivate() {
    }

    public UIQuestionsInfo() throws Exception {
        this.addChild(UIAnswersPageIterator.class, null, LIST_QUESTION_INTERATOR);
        this.addChild(UIAnswersPageIterator.class, null, LIST_QUESTION_NOT_ANSWERED_INTERATOR);
        this.setActions(new String[]{""});
    }

    public void setFAQSetting(FAQSetting setting) throws Exception {
        this.faqSetting_ = setting;
        FAQUtils.getEmailSetting((FAQSetting)this.faqSetting_, (boolean)false, (boolean)false);
        this.setListCate();
        UIFormSelectBox selectCategory = new UIFormSelectBox(LIST_CATEGORIES, LIST_CATEGORIES, this.listCategories);
        selectCategory.setOnChange("ChangeCategory");
        this.addUIFormInput((UIFormInput)selectCategory);
        this.setListQuestion();
    }

    protected boolean hasInGroup(List<String> listGroup, String[] listPermission) {
        for (String per : listPermission) {
            if (per == null || per.trim().length() <= 0 || !listGroup.contains(per)) continue;
            return true;
        }
        return false;
    }

    private void setListCate() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        this.listCategories.add(new SelectItemOption(res.getString("UIQuestionsInfo.label.All"), (Object)Utils.ALL));
        FAQService faqService = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        if (this.faqSetting_.isAdmin()) {
            List listCate = faqService.listingCategoryTree();
            this.listCategories.add(new SelectItemOption(this.getFAQService().getCategoryNameOf("categories"), (Object)"categories"));
            for (Cate cat : listCate) {
                this.listCategories.add(new SelectItemOption(cat.getCategory().getName(), (Object)cat.getCategory().getPath()));
            }
        } else {
            List listCate = this.getFAQService().getListCateIdByModerator(FAQUtils.getCurrentUser());
            this.moderateCates.clear();
            for (String str : listCate) {
                try {
                    int idxOfSemicolon = str.indexOf(CommonUtils.SEMICOLON);
                    this.listCategories.add(new SelectItemOption(str.substring(idxOfSemicolon + 1), (Object)str.substring(0, idxOfSemicolon)));
                    this.moderateCates.add(str.substring(0, idxOfSemicolon));
                }
                catch (StringIndexOutOfBoundsException e) {
                    if (str.indexOf("categories") != 0) continue;
                    this.listCategories.add(new SelectItemOption(str.substring("categories".length()), (Object)"categories"));
                    this.moderateCates.add("categories");
                }
                catch (Exception e) {
                    this.log.error((Object)("Can not set List Category, exception: " + e.getMessage()));
                }
            }
        }
    }

    protected String[] getQuestionActions() {
        return new String[]{"AddLanguage", "Attachment", "Save", "Close"};
    }

    protected String[] getQuestionNotAnsweredActions() {
        return new String[]{"QuestionRelation", "Attachment", "Save", "Close"};
    }

    protected String[] getTab() {
        return new String[]{"Question managerment", "Question not yet answered"};
    }

    protected boolean getIsEdit() {
        return this.isEditTab_;
    }

    protected boolean getIsResponse() {
        return this.isResponseTab_;
    }

    protected long getTotalpages(String pageInteratorId) {
        UIAnswersPageIterator pageIterator = (UIAnswersPageIterator)this.getChildById(pageInteratorId);
        try {
            return (Long)pageIterator.getInfoPage().get(3);
        }
        catch (Exception e) {
            this.log.error((Object)("Can not get tatal pages, exception: " + e.getMessage()));
            return 1L;
        }
    }

    public void setListQuestion() throws Exception {
        this.listQuestion_.clear();
        this.listQuestionNotYetAnswered_.clear();
        this.pageIterator = (UIAnswersPageIterator)this.getChildById(LIST_QUESTION_INTERATOR);
        this.pageQuesNotAnswerIterator = (UIAnswersPageIterator)this.getChildById(LIST_QUESTION_NOT_ANSWERED_INTERATOR);
        if (this.faqSetting_.isAdmin()) {
            if (this.cateId_.equals(Utils.ALL)) {
                this.pageList = this.getFAQService().getAllQuestions();
                this.pageListNotAnswer = this.getFAQService().getQuestionsNotYetAnswer(Utils.ALL, false);
            } else {
                String cateId = this.cateId_;
                if (cateId.indexOf("/") > 0) {
                    cateId = cateId.substring(cateId.lastIndexOf("/") + 1);
                }
                this.pageList = this.getFAQService().getAllQuestionsByCatetory(cateId, this.faqSetting_);
                this.pageListNotAnswer = this.getFAQService().getQuestionsNotYetAnswer(cateId, false);
            }
            this.pageList.setPageSize(5L);
            this.pageIterator.updatePageList(this.pageList);
            this.pageListNotAnswer.setPageSize(5L);
            this.pageQuesNotAnswerIterator.updatePageList(this.pageListNotAnswer);
        } else {
            ArrayList<String> listCateId = new ArrayList<String>();
            if (this.cateId_.equals(Utils.ALL)) {
                listCateId.addAll(this.moderateCates);
            } else if (this.cateId_.indexOf("/") > 0) {
                listCateId.add(this.cateId_.substring(this.cateId_.lastIndexOf("/") + 1));
            } else {
                listCateId.add(this.cateId_);
            }
            if (listCateId.size() > 0) {
                this.pageList = this.getFAQService().getQuestionsByListCatetory(listCateId, false);
                this.pageList.setPageSize(5L);
                this.pageIterator.updatePageList(this.pageList);
                this.pageListNotAnswer = this.getFAQService().getQuestionsByListCatetory(listCateId, true);
                this.pageListNotAnswer.setPageSize(5L);
                this.pageQuesNotAnswerIterator.updatePageList(this.pageListNotAnswer);
            }
        }
    }

    protected String getCategoryPath(String questionPath) {
        try {
            return this.getFAQService().getParentCategoriesName(questionPath.substring(0, questionPath.indexOf("/" + Utils.QUESTION_HOME)));
        }
        catch (Exception e) {
            this.log.error((Object)("Can not get category path, exception: " + e.getMessage()));
            return questionPath;
        }
    }

    protected List<Question> getListQuestion() {
        if (!this.isChangeTab_) {
            this.pageSelect = this.pageIterator.getPageSelected();
            this.listQuestion_ = new ArrayList();
            try {
                this.listQuestion_.addAll(this.pageList.getPage(this.pageSelect, null));
                if (this.listQuestion_.isEmpty()) {
                    UIAnswersPageIterator pageIterator = null;
                    while (this.listQuestion_.isEmpty() && this.pageSelect > 1L) {
                        pageIterator = (UIAnswersPageIterator)this.getChildById(LIST_QUESTION_INTERATOR);
                        this.listQuestion_.addAll(this.pageList.getPage(--this.pageSelect, null));
                        pageIterator.setSelectPage(this.pageSelect);
                    }
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Can not get list Question, exception: " + e.getMessage()));
            }
        }
        this.isChangeTab_ = false;
        return this.listQuestion_;
    }

    protected List<Question> getListQuestionNotAnswered() {
        if (!this.isChangeTab_) {
            this.pageSelectNotAnswer = this.pageQuesNotAnswerIterator.getPageSelected();
            this.listQuestionNotYetAnswered_.clear();
            try {
                this.listQuestionNotYetAnswered_.addAll(this.pageListNotAnswer.getPage(this.pageSelectNotAnswer, null));
                UIAnswersPageIterator pageIterator = null;
                while (this.listQuestionNotYetAnswered_.isEmpty() && this.pageSelectNotAnswer > 1L) {
                    pageIterator = (UIAnswersPageIterator)this.getChildById(LIST_QUESTION_NOT_ANSWERED_INTERATOR);
                    this.listQuestionNotYetAnswered_.addAll(this.pageListNotAnswer.getPage(--this.pageSelectNotAnswer, null));
                    pageIterator.setSelectPage(this.pageSelectNotAnswer);
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Can not get list Question not Answered, exception: " + e.getMessage()));
            }
        }
        this.isChangeTab_ = false;
        return this.listQuestionNotYetAnswered_;
    }

    static /* synthetic */ FAQService access$000(UIQuestionsInfo x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ FAQSetting access$100(UIQuestionsInfo x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ List access$200(UIQuestionsInfo x0) {
        return x0.listQuestion_;
    }

    static /* synthetic */ FAQService access$300(UIQuestionsInfo x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ FAQService access$400(UIQuestionsInfo x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ FAQService access$500(UIQuestionsInfo x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ String access$602(UIQuestionsInfo x0, String x1) {
        x0.cateId_ = x1;
        return x0.cateId_;
    }

    static /* synthetic */ boolean access$702(UIQuestionsInfo x0, boolean x1) {
        x0.isEditTab_ = x1;
        return x0.isEditTab_;
    }

    static /* synthetic */ boolean access$802(UIQuestionsInfo x0, boolean x1) {
        x0.isResponseTab_ = x1;
        return x0.isResponseTab_;
    }

    static /* synthetic */ boolean access$902(UIQuestionsInfo x0, boolean x1) {
        x0.isChangeTab_ = x1;
        return x0.isChangeTab_;
    }

    static /* synthetic */ FAQService access$1000(UIQuestionsInfo x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ FAQService access$1100(UIQuestionsInfo x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ Log access$1200(UIQuestionsInfo x0) {
        return x0.log;
    }
}

