/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.answer.rendering.RenderHelper;
import org.exoplatform.answer.rendering.RenderingException;
import org.exoplatform.answer.webui.FAQUtils;
import org.exoplatform.answer.webui.popup.UIPrintAllQuestions;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Question;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.webui.BaseUIForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/answer/webui/popup/UIPrintAllQuestions.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIPrintAllQuestions
extends BaseUIForm
implements UIPopupComponent {
    private String[] sizes_ = new String[]{"bytes", "KB", "MB"};
    private String categoryId = null;
    protected String currentUser_;
    private boolean canEditQuestion = false;
    private FAQService faqService_ = null;
    private FAQSetting faqSetting_ = null;
    protected boolean viewAuthorInfor = true;
    private RenderHelper renderHelper = new RenderHelper();

    public void activate() {
    }

    public void deActivate() {
    }

    public UIPrintAllQuestions() {
        try {
            this.currentUser_ = FAQUtils.getCurrentUser();
        }
        catch (Exception e) {
            this.log.debug((Object)"Current user must exist: ", (Throwable)e);
        }
    }

    protected String getQuestionRelationById(String questionId) {
        try {
            Question question = this.faqService_.getQuestionById(questionId);
            if (question != null) {
                return question.getCategoryId() + "/" + question.getId() + "/" + question.getQuestion();
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Can not get Question Relation by Id, exception: " + e.getMessage()));
        }
        return "";
    }

    public String getImageUrl(String imagePath) throws Exception {
        String url = "";
        try {
            url = CommonUtils.getImageUrl((String)imagePath);
        }
        catch (Exception e) {
            this.log.debug((Object)"Image must exist: ", (Throwable)e);
        }
        return url;
    }

    protected String getAvatarUrl(String userId) throws Exception {
        return FAQUtils.getUserAvatar((String)userId);
    }

    protected String convertSize(long size) {
        String result = "";
        long residual = 0L;
        int i = 0;
        while (size >= 1000L) {
            ++i;
            residual = size % 1024L;
            size /= 1024L;
        }
        result = residual > 500L ? size + 1L + " " + this.sizes_[i] : size + " " + this.sizes_[i];
        return result;
    }

    public void setCategoryId(String cateId, FAQService service, FAQSetting setting, boolean canEdit) throws Exception {
        this.categoryId = cateId;
        this.faqService_ = service;
        this.faqSetting_ = setting;
        this.viewAuthorInfor = this.faqService_.isViewAuthorInfo(this.categoryId);
        this.canEditQuestion = this.faqSetting_.isAdmin();
        if (!this.canEditQuestion) {
            this.canEditQuestion = canEdit;
        }
    }

    public String render(Object obj) throws RenderingException {
        if (obj instanceof Question) {
            return this.renderHelper.renderQuestion((Question)obj);
        }
        if (obj instanceof Answer) {
            return this.renderHelper.renderAnswer((Answer)obj);
        }
        if (obj instanceof Comment) {
            return this.renderHelper.renderComment((Comment)obj);
        }
        return "";
    }

    public List<Question> getListQuestion() {
        try {
            return this.faqService_.getQuestionsByCatetory(this.categoryId, this.faqSetting_).getAll();
        }
        catch (Exception e) {
            return new ArrayList<Question>();
        }
    }

    public String answer(Comment comment) {
        return comment.getComments();
    }

    public List<Answer> getListAnswers(String questionId) {
        try {
            return this.faqService_.getPageListAnswer(questionId, false).getPageItem(0L);
        }
        catch (Exception e) {
            return new ArrayList<Answer>();
        }
    }

    public List<Comment> getListComments(String questionId) {
        try {
            return this.faqService_.getPageListComment(questionId).getPageItem(0L);
        }
        catch (Exception e) {
            return new ArrayList<Comment>();
        }
    }
}

