/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.answer.webui.popup.UISelectCategoryForumForm;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/answer/webui/popup/UISelectCategoryForumForm.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddCategoryActionListener.class}, phase=Event.Phase.DECODE)})
public class UISelectCategoryForumForm
extends UIForm
implements UIPopupComponent {
    private List<Category> listcate = new ArrayList();
    private ForumService forumService;
    private Log log = ExoLogger.getLogger(UISelectCategoryForumForm.class);

    public UISelectCategoryForumForm() {
        this.forumService = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
    }

    public void setListCategory() throws Exception {
        this.listcate = this.forumService.getCategories();
    }

    List<Forum> getForums(String categoryId) {
        List<Object> listForum = new ArrayList<Forum>();
        if (categoryId != null && categoryId.trim().length() > 0) {
            try {
                String strQuery = "@exo:isClosed='false' and @exo:isLock='false'";
                listForum = this.forumService.getForums(categoryId, strQuery);
            }
            catch (Exception e) {
                this.log.error((Object)"Fail to get forums: ", (Throwable)e);
            }
        }
        return listForum;
    }

    protected List<Category> getCategories() throws Exception {
        return this.listcate;
    }

    public void activate() {
    }

    public void deActivate() {
    }

    private List<String> getPathName(String allPath) throws Exception {
        int t = allPath.indexOf(";");
        ArrayList<String> list = new ArrayList<String>();
        if (t > 0) {
            list.add(allPath.substring(0, t));
            list.add(allPath.substring(t + 1));
        }
        return list;
    }

    static /* synthetic */ List access$000(UISelectCategoryForumForm x0, String x1) throws Exception {
        return x0.getPathName(x1);
    }
}

