/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.webui.popup;

import org.exoplatform.answer.rendering.RenderHelper;
import org.exoplatform.answer.webui.BaseUIFAQForm;
import org.exoplatform.answer.webui.FAQUtils;
import org.exoplatform.answer.webui.popup.UICommentForm;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.webui.WebUIUtils;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/answer/webui/popup/UICommentForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UICommentForm
extends BaseUIFAQForm
implements UIPopupComponent {
    private String languageSelected;
    private Question question_;
    private Comment comment;
    private String questionContent;
    private String questionDetail;
    private String currentUser_ = "";
    private String currentUserDisplayName = "";
    private final String COMMENT_CONTENT = "CommentContent";
    private FAQSetting faqSetting_;
    private RenderHelper renderHelper = new RenderHelper();

    public UICommentForm() throws Exception {
        this.currentUser_ = FAQUtils.getCurrentUser();
        UIFormWYSIWYGInput commentContent = new UIFormWYSIWYGInput("CommentContent", "CommentContent", "");
        commentContent.setFCKConfig(WebUIUtils.getFCKConfig());
        commentContent.setToolBarName("Basic");
        this.addChild((UIComponent)commentContent);
        User user = FAQUtils.getCurrentUserObject();
        if (user != null) {
            String fullName = FAQUtils.getFullName((String)user.getUserName());
            this.currentUserDisplayName = fullName == null || fullName.length() == 0 ? user.getUserName() : fullName;
        }
    }

    public String getCurrentUserDisplayName() {
        return this.currentUserDisplayName;
    }

    public void setCurrentUserDisplayName(String currentUserDisplayName) {
        this.currentUserDisplayName = currentUserDisplayName;
    }

    public String getQuestionContent() {
        return this.questionContent;
    }

    protected String getQuestionDetail() {
        Question question = new Question();
        question.setDetail(this.questionDetail);
        return CommonUtils.decodeSpecialCharToHTMLnumber((String)this.renderHelper.renderQuestion(question));
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public void setInfor(Question question, String commentId, FAQSetting faqSetting, String language) throws Exception {
        if (!language.equals(question.getLanguage())) {
            try {
                QuestionLanguage questionLanguage = this.getFAQService().getQuestionLanguageByLanguage(question.getPath(), language);
                this.questionContent = questionLanguage.getQuestion();
                this.questionDetail = questionLanguage.getDetail();
                this.languageSelected = language;
            }
            catch (Exception e) {
                this.questionContent = question.getQuestion();
                this.questionDetail = question.getDetail();
                this.languageSelected = question.getLanguage();
            }
        } else {
            this.questionContent = question.getQuestion();
            this.questionDetail = question.getDetail();
            this.languageSelected = question.getLanguage();
        }
        this.question_ = question;
        this.faqSetting_ = faqSetting;
        FAQUtils.getEmailSetting((FAQSetting)this.faqSetting_, (boolean)false, (boolean)false);
        if (commentId.indexOf("new") < 0) {
            this.comment = this.getFAQService().getCommentById(question.getPath(), commentId, language);
            ((UIFormWYSIWYGInput)this.getChildById("CommentContent")).setValue((Object)CommonUtils.decodeSpecialCharToHTMLnumber((String)this.comment.getComments()));
        }
    }

    static /* synthetic */ Question access$000(UICommentForm x0) {
        return x0.question_;
    }

    static /* synthetic */ FAQService access$100(UICommentForm x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ Comment access$200(UICommentForm x0) {
        return x0.comment;
    }

    static /* synthetic */ Comment access$202(UICommentForm x0, Comment x1) {
        x0.comment = x1;
        return x0.comment;
    }

    static /* synthetic */ String access$300(UICommentForm x0) {
        return x0.currentUser_;
    }

    static /* synthetic */ Log access$400(UICommentForm x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$500(UICommentForm x0) {
        return x0.log;
    }

    static /* synthetic */ String access$600(UICommentForm x0) {
        return x0.languageSelected;
    }

    static /* synthetic */ FAQService access$700(UICommentForm x0) {
        return x0.getFAQService();
    }

    static /* synthetic */ Log access$800(UICommentForm x0) {
        return x0.log;
    }
}

