/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.webui.popup;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.answer.webui.FAQUtils;
import org.exoplatform.answer.webui.UIAnswersPageIterator;
import org.exoplatform.answer.webui.popup.UIUserWatchManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.JCRPageList;
import org.exoplatform.faq.service.Question;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

@ComponentConfig(template="app:/templates/answer/webui/popup/UIUserWatchManager.gtmpl", events={@EventConfig(listeners={LinkActionListener.class}), @EventConfig(listeners={UnWatchActionListener.class}, confirm="UIUserWatchManager.msg.confirm-unwatch-category")})
public class UIUserWatchManager
extends UIContainer {
    private FAQSetting faqSetting_ = null;
    protected UIAnswersPageIterator pageIteratorCate;
    protected JCRPageList pageListCate;
    private UIAnswersPageIterator pageIteratorQues;
    private UIAnswersPageIterator pageIteratorCates;
    private JCRPageList pageListQues;
    private JCRPageList pageListCates;
    private String LIST_QUESTIONS_WATCHED = "listQuestionsWatch";
    private String LIST_CATES_WATCHED = "listCatesWatch";
    private String emailAddress;
    private static FAQService faqService_;

    public UIUserWatchManager() throws Exception {
        this.setId("UIUswerWatchManager");
        this.addChild(UIAnswersPageIterator.class, null, this.LIST_QUESTIONS_WATCHED);
        this.addChild(UIAnswersPageIterator.class, null, this.LIST_CATES_WATCHED);
        this.emailAddress = FAQUtils.getEmailUser(null);
        faqService_ = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public List<Category> getListCategory() throws Exception {
        return this.getListCategoriesWatch();
    }

    public String getCategoriesName(String categoryId) throws Exception {
        return faqService_.getParentCategoriesName(categoryId);
    }

    public static String getSubPath(String path) {
        String[] paths;
        if (!FAQUtils.isFieldEmpty((String)path) && (paths = path.split(" > ")).length > 3) {
            return paths[0] + " > ... > " + paths[paths.length - 1];
        }
        return path;
    }

    public void setFAQSetting(FAQSetting setting) {
        this.faqSetting_ = setting;
    }

    private List<Category> getListCategoriesWatch() {
        try {
            if (this.pageListCates == null) {
                this.pageListCates = faqService_.getWatchedCategoryByUser(FAQUtils.getCurrentUser());
                this.pageListCates.setPageSize(5L);
                this.pageIteratorCates = (UIAnswersPageIterator)this.getChildById(this.LIST_CATES_WATCHED);
                this.pageIteratorCates.updatePageList(this.pageListCates);
            }
            long pageSelect = this.pageIteratorCates.getPageSelected();
            ArrayList<Category> listCategories = new ArrayList<Category>();
            listCategories.addAll(this.pageListCates.getPageResultCategoriesSearch(pageSelect, null));
            if (listCategories.isEmpty()) {
                UIAnswersPageIterator pageIterator = null;
                while (listCategories.isEmpty() && pageSelect > 1L) {
                    pageIterator = (UIAnswersPageIterator)this.getChildById(this.LIST_CATES_WATCHED);
                    listCategories.addAll(this.pageListCates.getPageResultCategoriesSearch(--pageSelect, null));
                    pageIterator.setSelectPage(pageSelect);
                }
            }
            return listCategories;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected List<Question> getListQuestionsWatch() {
        try {
            if (this.pageListQues == null) {
                this.pageListQues = faqService_.getListQuestionsWatch(this.faqSetting_, FAQUtils.getCurrentUser());
                this.pageListQues.setPageSize(5L);
                this.pageIteratorQues = (UIAnswersPageIterator)this.getChildById(this.LIST_QUESTIONS_WATCHED);
                this.pageIteratorQues.updatePageList(this.pageListQues);
            }
            long pageSelect = this.pageIteratorQues.getPageSelected();
            ArrayList<Question> listQuestion_ = new ArrayList<Question>();
            listQuestion_.addAll(this.pageListQues.getPage(pageSelect, null));
            if (listQuestion_.isEmpty()) {
                UIAnswersPageIterator pageIterator = null;
                while (listQuestion_.isEmpty() && pageSelect > 1L) {
                    pageIterator = (UIAnswersPageIterator)this.getChildById(this.LIST_QUESTIONS_WATCHED);
                    listQuestion_.addAll(this.pageListQues.getPage(--pageSelect, null));
                    pageIterator.setSelectPage(pageSelect);
                }
            }
            return listQuestion_;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected long getTotalpages(String pageInteratorId) {
        UIAnswersPageIterator pageIterator = (UIAnswersPageIterator)this.getChildById(pageInteratorId);
        try {
            return (Long)pageIterator.getInfoPage().get(3);
        }
        catch (Exception e) {
            return 1L;
        }
    }

    static /* synthetic */ FAQService access$000() {
        return faqService_;
    }
}

