/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.webui;

import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.exoplatform.answer.webui.FAQUtils;
import org.exoplatform.answer.webui.UIAnswersContainer;
import org.exoplatform.answer.webui.UIBreadcumbs;
import org.exoplatform.answer.webui.UICategories;
import org.exoplatform.answer.webui.UIQuestions;
import org.exoplatform.answer.webui.popup.UIAnswerEditModeForm;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.forum.common.UserHelper;
import org.exoplatform.forum.common.webui.UIPopupAction;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.form.UIFormInputInfo;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/answer/webui/UIAnswersPortlet.gtmpl")
public class UIAnswersPortlet
extends UIPortletApplication {
    private static final String SLASH = "/".intern();
    private String spaceGroupId = null;
    private PortletMode portletMode;

    public UIAnswersPortlet() throws Exception {
        UIFormInputInfo changeModeMessage = new UIFormInputInfo("UIMessageEditMode", "UIMessageEditMode", "");
        changeModeMessage.setRendered(false);
        this.addChild((UIComponent)changeModeMessage);
        this.addChild(UIAnswersContainer.class, null, null);
        UIPopupAction uiPopup = (UIPopupAction)this.addChild(UIPopupAction.class, null, null);
        uiPopup.setId("UIAnswersPopupAction");
        ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setId("UIAnswersPopupWindow");
    }

    public String getSpaceCategoryId() {
        try {
            PortalRequestContext plcontext = Util.getPortalRequestContext();
            String requestPath = plcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
            ExoRouter.Route route = ExoRouter.route((String)requestPath);
            if (route == null) {
                return null;
            }
            String spacePrettyName = (String)route.localArgs.get("spacePrettyName");
            if (spacePrettyName != null) {
                SpaceService sService = (SpaceService)this.getApplicationComponent(SpaceService.class);
                Space space = sService.getSpaceByPrettyName(spacePrettyName);
                this.spaceGroupId = space.getGroupId();
                String categoryId = Utils.CATE_SPACE_ID_PREFIX + this.spaceGroupId.replaceAll("/spaces/", "");
                FAQService fService = (FAQService)this.getApplicationComponent(FAQService.class);
                if (fService.isExisting("categories" + SLASH + categoryId)) {
                    return categoryId;
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        this.portletMode = portletReqContext.getApplicationMode();
        UIFormInputInfo formInputInfo = (UIFormInputInfo)((UIFormInputInfo)this.getChild(UIFormInputInfo.class)).setRendered(false);
        if (this.portletMode == PortletMode.VIEW) {
            if (this.getChild(UIAnswersContainer.class) == null) {
                if (this.getChild(UIAnswerEditModeForm.class) != null) {
                    this.removeChild(UIAnswerEditModeForm.class);
                }
                this.addChild(UIAnswersContainer.class, null, null);
            }
            this.renderPortletByURL();
        } else if (this.portletMode == PortletMode.EDIT) {
            try {
                FAQService fService = (FAQService)this.getApplicationComponent(FAQService.class);
                if (fService.isAdminRole(UserHelper.getCurrentUser())) {
                    UIAnswerEditModeForm settingForm = (UIAnswerEditModeForm)this.getChild(UIAnswerEditModeForm.class);
                    if (settingForm == null) {
                        settingForm = (UIAnswerEditModeForm)this.addChild(UIAnswerEditModeForm.class, null, "FAQPortletSetting");
                        settingForm.initContainer();
                    }
                    settingForm.setRendered(true);
                } else {
                    String infoMessage = context.getApplicationResourceBundle().getString("UIAnswersPortlet.label.deny-access-edit-mode");
                    ((UIFormInputInfo)formInputInfo.setRendered(true)).setValue((Object)infoMessage);
                }
                if (this.getChild(UIAnswersContainer.class) != null) {
                    this.removeChild(UIAnswersContainer.class);
                }
            }
            catch (Exception e) {
                log.error((Object)"\nFail to render a WebUIApplication\n", (Throwable)e);
            }
        }
        super.processRender(app, context);
    }

    public void renderPortletByURL() throws Exception {
        try {
            PortalRequestContext portalContext = Util.getPortalRequestContext();
            String cateId = this.getSpaceCategoryId();
            if (portalContext.getRequestParameter("objectId") == null && !portalContext.useAjax()) {
                if (!FAQUtils.isFieldEmpty((String)cateId)) {
                    UIBreadcumbs uiBreadcums = (UIBreadcumbs)this.findFirstComponentOfType(UIBreadcumbs.class);
                    UIQuestions uiQuestions = (UIQuestions)this.findFirstComponentOfType(UIQuestions.class);
                    UICategories categories = (UICategories)this.findFirstComponentOfType(UICategories.class);
                    uiBreadcums.setUpdataPath("categories" + SLASH + cateId);
                    uiBreadcums.setRenderSearch(true);
                    uiQuestions.setCategoryId("categories" + SLASH + cateId);
                    categories.setPathCategory("categories" + SLASH + cateId);
                } else {
                    String questionId = portalContext.getRequestParameter("questionId");
                    String asn = portalContext.getRequestParameter("answer-now");
                    if (!FAQUtils.isFieldEmpty((String)questionId)) {
                        this.viewQuestionById((WebuiRequestContext)portalContext, questionId, Boolean.valueOf(asn).booleanValue(), false);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"can not render the selected category", (Throwable)e);
        }
    }

    public String getSpaceGroupId() {
        return this.spaceGroupId;
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    public static String getPreferenceDisplay() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String repository = portletPref.getValue("display", "");
        return repository;
    }

    private void showMessageDeletedQuestion(WebuiRequestContext context) throws Exception {
        context.getUIApplication().addMessage(new ApplicationMessage("UIQuestions.msg.question-id-deleted", null, 1));
        context.addUIComponentToUpdateByAjax((UIComponent)this);
    }

    public void viewQuestionById(WebuiRequestContext context, String questionId, boolean isAnswerNow, boolean isAction) throws Exception {
        UIQuestions uiQuestions = (UIQuestions)this.findFirstComponentOfType(UIQuestions.class);
        FAQService faqService_ = (FAQService)this.getApplicationComponent(FAQService.class);
        uiQuestions.isSortAnswerUp = null;
        try {
            Question question;
            boolean isRelation = false;
            boolean isSetLang = true;
            if (questionId.indexOf("/language=") > 0) {
                String[] array = questionId.split("/language=");
                questionId = array[0];
                if (array[1].indexOf("/relation=") > 0) {
                    isRelation = true;
                    if (!FAQUtils.isFieldEmpty((String)uiQuestions.viewingQuestionId_)) {
                        uiQuestions.backPath_ = uiQuestions.viewingQuestionId_ + "/language=" + uiQuestions.language_ + "/back";
                    }
                } else {
                    if (array[1].indexOf("/back") > 0) {
                        isRelation = true;
                        array[1] = array[1].replaceFirst("/back", "");
                    }
                    isSetLang = false;
                    uiQuestions.language_ = array[1];
                    uiQuestions.backPath_ = "";
                }
            }
            if ((question = faqService_.getQuestionById(questionId)) == null) {
                this.showMessageDeletedQuestion(context);
                return;
            }
            if (uiQuestions.checkQuestionToView(question, context)) {
                String questionPath = question.getPath();
                UIBreadcumbs breadcumbs = (UIBreadcumbs)this.findFirstComponentOfType(UIBreadcumbs.class);
                String categoryPath = question.getCategoryPath();
                breadcumbs.setUpdataPath(categoryPath);
                UICategories categories = (UICategories)this.findFirstComponentOfType(UICategories.class);
                categories.setPathCategory(breadcumbs.getPaths());
                uiQuestions.setCategoryId(categoryPath);
                uiQuestions.updateCurrentQuestionList();
                uiQuestions.pageList.setObjectId(questionPath);
                if (!isAction) {
                    uiQuestions.viewQuestion(question);
                }
                uiQuestions.viewingQuestionId_ = questionPath;
                if (isRelation) {
                    uiQuestions.updateLanguageMap();
                }
                if (isSetLang) {
                    uiQuestions.language_ = question.getLanguage();
                } else {
                    uiQuestions.updateCurrentLanguage();
                }
                uiQuestions.updateQuestionLanguageByLanguage(questionPath, question.getLanguage());
                if (isAnswerNow) {
                    uiQuestions.processResponseQuestionAction(context, questionPath);
                }
                context.addUIComponentToUpdateByAjax(this.getChild(UIAnswersContainer.class));
            }
            return;
        }
        catch (Exception e) {
            log.debug((Object)("Failed to view question by id: " + questionId), (Throwable)e);
            uiQuestions.showMessageDeletedQuestion(context);
            return;
        }
    }
}

