/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.answer.webui.BaseUIFAQForm;
import org.exoplatform.answer.webui.FAQDownloadResource;
import org.exoplatform.answer.webui.UIAnswersContainer;
import org.exoplatform.answer.webui.UIBreadcumbs;
import org.exoplatform.answer.webui.UICategories;
import org.exoplatform.answer.webui.UIQuestions;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.CategoryTree;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.UserHelper;
import org.exoplatform.forum.common.user.CommonContact;
import org.exoplatform.forum.common.user.ContactProvider;
import org.exoplatform.forum.common.webui.WebUIUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.utils.TimeConvertUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FAQUtils {
    public static String DISPLAYAPPROVED = "approved";
    public static String DISPLAYBOTH = "both";
    public static String UPLOAD_FILE_SIZE = "uploadFileSizeLimitMB";
    public static String UPLOAD_AVATAR_SIZE = "uploadAvatarSizeLimitMB";
    public static final String COMMA = ",".intern();
    public static final int DEFAULT_VALUE_UPLOAD_PORTAL = -1;
    private static Log log = ExoLogger.getLogger(FAQUtils.class);

    public static FAQService getFAQService() throws Exception {
        return (FAQService)PortalContainer.getComponent(FAQService.class);
    }

    public static String getDefaultLanguage() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        return context.getLocale().getDisplayLanguage();
    }

    public static List<String> getAllLanguages(UIComponent component) {
        LocaleConfigService configService = (LocaleConfigService)component.getApplicationComponent(LocaleConfigService.class);
        ArrayList<String> languages = new ArrayList<String>();
        for (LocaleConfig localeConfig : configService.getLocalConfigs()) {
            languages.add(localeConfig.getLocale().getDisplayLanguage());
        }
        return languages;
    }

    public static void findCateExist(FAQService faqService_, UIAnswersContainer fAQContainer) throws Exception {
        UIBreadcumbs breadcumbs = (UIBreadcumbs)fAQContainer.findFirstComponentOfType(UIBreadcumbs.class);
        String pathCate = "";
        for (String path : ((String)breadcumbs.pathList_.get(breadcumbs.pathList_.size() - 1)).split("/")) {
            if (path.equals("FAQService")) {
                pathCate = path;
                continue;
            }
            try {
                faqService_.getCategoryById(path);
                if (pathCate.trim().length() > 0) {
                    pathCate = pathCate + "/";
                }
                pathCate = pathCate + path;
            }
            catch (Exception pathExc) {
                UIQuestions questions = (UIQuestions)fAQContainer.findFirstComponentOfType(UIQuestions.class);
                try {
                    breadcumbs.setUpdataPath(pathCate);
                }
                catch (Exception exc) {
                    log.debug((Object)("Setting update path fail: " + exc.getMessage()), (Throwable)exc);
                }
                if (pathCate.indexOf("/") > 0) {
                    questions.setCategoryId(pathCate.substring(pathCate.lastIndexOf("/") + 1));
                } else {
                    questions.categoryId_ = null;
                    questions.setListObject();
                }
                ((UICategories)fAQContainer.findFirstComponentOfType(UICategories.class)).setPathCategory(pathCate);
                break;
            }
        }
    }

    public static String getCategoryPathName(String categoryPathName, boolean isReplaceIcon) {
        if (FAQUtils.isFieldEmpty((String)categoryPathName)) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(WebUIUtils.getLabel((String)"UIBreadcumbs", (String)"categories"));
        categoryPathName = categoryPathName.replaceFirst("categories", "");
        if (isReplaceIcon) {
            categoryPathName = categoryPathName.replaceAll(" > ", "<i class=\"uiIconArrowRightMini uiIconLightGray\"></i>");
        }
        return buffer.append(categoryPathName).toString();
    }

    public static InternetAddress[] getInternetAddress(String addressList) throws Exception {
        if (FAQUtils.isFieldEmpty((String)addressList)) {
            return new InternetAddress[1];
        }
        try {
            return InternetAddress.parse((String)addressList);
        }
        catch (Exception e) {
            return new InternetAddress[1];
        }
    }

    public static String[] splitForFAQ(String str) throws Exception {
        if (!FAQUtils.isFieldEmpty((String)str)) {
            String[] strs = new String[]{str};
            if (str.contains(COMMA)) {
                str = str.trim().replaceAll("(,\\s*)", COMMA).replaceAll("(\\s*,)", COMMA).replaceAll("(,,*)", COMMA);
                strs = str.trim().split(",");
            } else if (str.contains(";")) {
                str = str.trim().replaceAll("(;\\s*)", ";").replaceAll("(\\s*;)", ";").replaceAll("(;;*)", ";");
                strs = str.split(";");
            }
            return strs;
        }
        return new String[0];
    }

    public static String getCurrentUser() throws Exception {
        return UserHelper.getCurrentUser();
    }

    public static User getCurrentUserObject() throws Exception {
        try {
            ConversationState state = ConversationState.getCurrent();
            User user = (User)state.getAttribute("UserProfile");
            if (user == null) {
                user = UserHelper.getUserByUserId((String)state.getIdentity().getUserId());
            }
            return user;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getEmailUser(String userName) throws Exception {
        if (userName == null) {
            return FAQUtils.getCurrentUserObject().getEmail();
        }
        return UserHelper.getEmailUser((String)userName);
    }

    public static String getFullName(String userName) {
        try {
            if (CommonUtils.isEmpty((String)userName)) {
                return FAQUtils.getUserFullName((User)FAQUtils.getCurrentUserObject());
            }
            return FAQUtils.getUserFullName((User)UserHelper.getUserByUserId((String)userName));
        }
        catch (Exception e) {
            return FAQUtils.getScreenName((String)userName, (String)"");
        }
    }

    public static String getUserFullName(User user) {
        if (user == null) {
            return "";
        }
        String displayName = user.getDisplayName();
        if (CommonUtils.isEmpty((String)displayName)) {
            displayName = new StringBuffer(user.getFirstName()).append(" ").append(user.getLastName()).toString();
        }
        return displayName;
    }

    public static String getScreenName(String userName, String fullName) {
        return userName.contains(org.exoplatform.faq.service.Utils.DELETED) ? "<s>" + (CommonUtils.isEmpty((String)fullName) ? userName.substring(0, userName.indexOf(org.exoplatform.faq.service.Utils.DELETED)) : fullName) + "</s>" : userName;
    }

    public static boolean isFieldEmpty(String s) {
        return CommonUtils.isEmpty((String)s);
    }

    public static boolean isValidEmailAddresses(String addressList) throws Exception {
        if (FAQUtils.isFieldEmpty((String)addressList)) {
            return true;
        }
        boolean isInvalid = true;
        try {
            InternetAddress[] iAdds = InternetAddress.parse((String)addressList, (boolean)true);
            String emailRegex = "[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+\\.[A-Za-z]{2,5}";
            for (int i = 0; i < iAdds.length; ++i) {
                if (iAdds[i].getAddress().matches(emailRegex)) continue;
                isInvalid = false;
            }
        }
        catch (AddressException e) {
            return false;
        }
        return isInvalid;
    }

    public static String getSubString(String str, int max) {
        if (str.length() > max) {
            String newStr = str.substring(0, max - 3);
            return newStr.trim() + "...";
        }
        return str;
    }

    public static String getTitle(String text) {
        if (FAQUtils.isFieldEmpty((String)text)) {
            return "";
        }
        text = text.replaceAll("&nbsp;", " ").replaceAll("( \\s*)", " ");
        return StringUtils.replace((String)text, (String)"\"", (String)"&quot;");
    }

    public static List<String> getCategoriesIdFAQPortlet() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String str = portletPref.getValue("displayCategories", "");
        ArrayList<String> list = new ArrayList<String>();
        if (!FAQUtils.isFieldEmpty((String)str)) {
            list.addAll(Arrays.asList(str.split(",")));
        }
        return list;
    }

    public static boolean getUseAjaxFAQPortlet() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        return Boolean.parseBoolean(portletPref.getValue("useAjax", "false"));
    }

    public static void saveFAQPortletPreference(List<String> list, boolean useAjax) throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        if (list.size() > 0) {
            String str = list.toString();
            str = str.replace("[", "").replace("]", "").replaceAll(" ", "");
            portletPref.setValue("displayCategories", str);
        } else {
            portletPref.setValue("displayCategories", "");
        }
        portletPref.setValue("useAjax", String.valueOf(useAjax));
        portletPref.store();
    }

    public static void getPorletPreference(FAQSetting faqSetting) {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = pcontext.getApplicationResourceBundle();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        faqSetting.setEnableViewAvatar(Boolean.parseBoolean(portletPref.getValue("enableViewAvatar", "")));
        faqSetting.setEnableAutomaticRSS(Boolean.parseBoolean(portletPref.getValue("enableAutomaticRSS", "")));
        faqSetting.setEnanbleVotesAndComments(Boolean.parseBoolean(portletPref.getValue("enanbleVotesAndComments", "")));
        faqSetting.setEnableAnonymousSubmitQuestion(Boolean.parseBoolean(portletPref.getValue("enableAnonymousSubmitQuestion", "")));
        faqSetting.setDisplayMode(portletPref.getValue("display", ""));
        faqSetting.setOrderBy(portletPref.getValue("orderBy", ""));
        faqSetting.setOrderType(portletPref.getValue("orderType", ""));
        faqSetting.setIsDiscussForum(Boolean.parseBoolean(portletPref.getValue("isDiscussForum", "")));
        faqSetting.setIdNameCategoryForum(portletPref.getValue("idNameCategoryForum", ""));
        String emailMoveQuestion = portletPref.getValue("emailMoveQuestion", null);
        if (emailMoveQuestion == null || StringUtils.isEmpty((String)emailMoveQuestion.trim())) {
            faqSetting.setEmailMoveQuestion(res.getString("SendEmail.MoveQuetstion.Default"));
        } else {
            faqSetting.setEmailMoveQuestion(emailMoveQuestion);
        }
        faqSetting.setPostQuestionInRootCategory(Boolean.parseBoolean(portletPref.getValue("isPostQuestionInRootCategory", "true")));
    }

    public static void getEmailSetting(FAQSetting faqSetting, boolean isNew, boolean isSettingForm) {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String emailContent = "";
        if (isNew) {
            emailContent = portletPref.getValue("SendMailAddNewQuestion", "");
        } else if (isSettingForm) {
            emailContent = portletPref.getValue("SendMailEditResponseQuestion", "");
        }
        ResourceBundle res = pcontext.getApplicationResourceBundle();
        if (emailContent == null || emailContent.trim().length() < 1) {
            emailContent = isNew ? res.getString("SendEmail.AddNewQuestion.Default") : (isSettingForm ? res.getString("SendEmail.EditQuestion.Default") : res.getString("SendEmail.ResponseQuestion.Default"));
        }
        faqSetting.setEmailSettingSubject(res.getString("SendEmail.Default.Subject"));
        faqSetting.setEmailSettingContent(emailContent);
    }

    public static String getEmailMoveQuestion(FAQSetting faqSetting) {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String str = portletPref.getValue("emailMoveQuestion", "");
        if (FAQUtils.isFieldEmpty((String)str)) {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = context.getApplicationResourceBundle();
            str = res.getString("SendEmail.MoveQuetstion.Default");
        }
        faqSetting.setEmailMoveQuestion(str);
        return str;
    }

    public static void savePortletPreference(FAQSetting setting, String emailAddNewQuestion, String emailEditResponseQuestion) {
        try {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences portletPref = pcontext.getRequest().getPreferences();
            portletPref.setValue("display", setting.getDisplayMode());
            portletPref.setValue("orderBy", setting.getOrderBy());
            portletPref.setValue("orderType", setting.getOrderType());
            portletPref.setValue("isDiscussForum", String.valueOf(setting.getIsDiscussForum()));
            portletPref.setValue("idNameCategoryForum", setting.getIdNameCategoryForum());
            portletPref.setValue("enableAutomaticRSS", setting.isEnableAutomaticRSS() + "");
            portletPref.setValue("enableViewAvatar", setting.isEnableViewAvatar() + "");
            portletPref.setValue("enanbleVotesAndComments", setting.isEnanbleVotesAndComments() + "");
            portletPref.setValue("enableAnonymousSubmitQuestion", setting.isEnableAnonymousSubmitQuestion() + "");
            portletPref.setValue("SendMailAddNewQuestion", emailAddNewQuestion);
            portletPref.setValue("SendMailEditResponseQuestion", emailEditResponseQuestion);
            portletPref.setValue("emailMoveQuestion", setting.getEmailMoveQuestion());
            portletPref.setValue("isPostQuestionInRootCategory", setting.isPostQuestionInRootCategory() + "");
            portletPref.store();
        }
        catch (Exception e) {
            log.error((Object)"Fail to save portlet preferences: ", (Throwable)e);
        }
    }

    private static String getFormatDate(int dateFormat, Date myDate) {
        if (myDate == null) {
            return "";
        }
        String format = dateFormat == 1 ? "EEE, MMM dd, yyyy" : "MM/dd/yyyy";
        try {
            String userName = UserHelper.getCurrentUser();
            if (!FAQUtils.isFieldEmpty((String)userName)) {
                ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
                UserProfile profile = forumService.getUserSettingProfile(userName);
                format = dateFormat == 1 ? profile.getLongDateFormat() : profile.getShortDateFormat();
            }
        }
        catch (Exception e) {
            log.debug((Object)("No forum settings found for date format. Will use format " + format));
        }
        format = format.replaceAll("D", "E").replace("EEE,MMM", "EEE, MMM").replace("d,y", "d, y");
        return TimeConvertUtils.getFormatDate((Date)myDate, (String)format);
    }

    public static String getLongDateFormat(Date myDate) {
        return FAQUtils.getFormatDate((int)1, (Date)myDate);
    }

    public static String getShortDateFormat(Date myDate) {
        return FAQUtils.getFormatDate((int)3, (Date)myDate);
    }

    public static String getUserAvatar(String userName) {
        String url = "";
        try {
            FAQService service = FAQUtils.getFAQService();
            FileAttachment avatar = service.getUserAvatar(userName);
            if (avatar != null) {
                url = CommonUtils.getImageUrl((String)avatar.getPath()) + "?size=" + avatar.getSize();
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failed to get user avatar of user: " + userName), (Throwable)e);
        }
        if (url == null || url.trim().length() < 1) {
            CommonContact contact = FAQUtils.getPersonalContact((String)userName);
            if (!FAQUtils.isFieldEmpty((String)contact.getAvatarUrl())) {
                url = contact.getAvatarUrl();
            }
            url = url == null || url.trim().length() < 1 ? "/social-resources/skin/images/ShareImages/UserAvtDefault.png" : url;
        }
        return url;
    }

    public static CommonContact getPersonalContact(String userId) {
        try {
            if (userId.indexOf(org.exoplatform.faq.service.Utils.DELETED) > 0) {
                return new CommonContact();
            }
            ContactProvider provider = (ContactProvider)PortalContainer.getComponent(ContactProvider.class);
            return provider.getCommonContact(userId);
        }
        catch (Exception e) {
            return new CommonContact();
        }
    }

    public static String getFileSource(FileAttachment attachment) throws Exception {
        DownloadService dservice = (DownloadService)PortalContainer.getComponent(DownloadService.class);
        try {
            FAQDownloadResource dresource = new FAQDownloadResource(attachment.getMimeType(), "image");
            dresource.setFileAttachment(attachment);
            dresource.setDownloadName(attachment.getName());
            return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
        }
        catch (Exception e) {
            log.error((Object)("Can not get File Source, exception: " + e.getMessage()));
            return "";
        }
    }

    public static String getPortletURI() {
        try {
            PortalRequestContext portalContext = Util.getPortalRequestContext();
            String selectedNode = Util.getUIPortal().getSelectedUserNode().getURI();
            return portalContext.getPortalURI() + selectedNode;
        }
        catch (Exception e) {
            return Util.getPortalRequestContext().getRequest().getRequestURL().toString();
        }
    }

    public static String getPortletURL() {
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String fullUrl = Util.getPortalRequestContext().getRequest().getRequestURL().toString();
        try {
            String host = fullUrl.substring(0, fullUrl.indexOf("/", 8));
            String selectedNode = Util.getUIPortal().getSelectedUserNode().getURI();
            return host + portalContext.getPortalURI() + selectedNode;
        }
        catch (Exception e) {
            return fullUrl;
        }
    }

    public static String getQuestionURI(String param, boolean isAnswer) throws Exception {
        return FAQUtils.getPortletURI() + org.exoplatform.faq.service.Utils.QUESTION_ID + param + (isAnswer ? org.exoplatform.faq.service.Utils.ANSWER_NOW + "true" : "");
    }

    public static String getQuestionURL(String param, boolean isAnswer) throws Exception {
        return FAQUtils.getPortletURL() + org.exoplatform.faq.service.Utils.QUESTION_ID + param + (isAnswer ? org.exoplatform.faq.service.Utils.ANSWER_NOW + "true" : "");
    }

    public static String getLinkDiscuss(String topicId) throws Exception {
        try {
            PortalRequestContext portalContext = Util.getPortalRequestContext();
            String link = portalContext.getPortalURI().concat("forum/").concat(Utils.TOPIC).concat("/").concat(topicId);
            return link;
        }
        catch (Exception e) {
            log.error((Object)"Fail to get link discuss: ", (Throwable)e);
            return "";
        }
    }

    public static int getLimitUploadSize(boolean isAvatar) {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        int limitMB = -1;
        limitMB = isAvatar ? Integer.parseInt(portletPref.getValue(UPLOAD_AVATAR_SIZE, "").trim()) : Integer.parseInt(portletPref.getValue(UPLOAD_FILE_SIZE, "").trim());
        return limitMB;
    }

    public static String renderCategoryTree(CategoryTree categoryTree, BaseUIFAQForm uiForm, String actionName, String categoryId, boolean isAddSup) throws Exception {
        StringBuilder builder = new StringBuilder();
        Category category = categoryTree.getCategory();
        if (FAQUtils.hasPermission((Category)category)) {
            List categoryTrees = categoryTree.getSubCategory();
            String clazz = "collapseIcon";
            if (categoryTrees.size() == 0) {
                clazz = "uiIconEmpty";
            }
            builder.append("<a href=\"javascript:void(0);\"");
            if (!isAddSup && category.getId().equals(categoryId)) {
                String warning = uiForm.i18n("UIMoveQuestionForm.msg.choice-orther");
                builder.append(" ondblclick=\"alert('").append(warning).append("');\"");
            } else {
                builder.append(" ondblclick=\"").append(uiForm.event(actionName, category.getId())).append("\"");
            }
            if (!category.getId().equals("categories")) {
                builder.append(" class=\"uiIconNode ").append(clazz).append("\" onclick=\"eXo.answer.AnswerUtils.showTreeNode(this);\">").append("<i class=\"uiIconCategory uiIconLightGray\"></i>").append(category.getName());
            } else {
                String home = uiForm.i18n("UICategoryTree.label.home");
                builder.append(">").append("<i class=\"uiIconHome uiIconLightGray\"></i>  <span>").append(home).append("</span>");
            }
            builder.append("</a>");
            if (categoryTrees.size() > 0) {
                builder.append("<ul class=\"nodeGroup\">");
                for (CategoryTree subTree : categoryTrees) {
                    String subCategoryInfo;
                    if (isAddSup && subTree.getCategory().getPath().indexOf(categoryId) >= 0 || CommonUtils.isEmpty((String)(subCategoryInfo = FAQUtils.renderCategoryTree((CategoryTree)subTree, (BaseUIFAQForm)uiForm, (String)actionName, (String)categoryId, (boolean)isAddSup)))) continue;
                    builder.append("<li class=\"node\">");
                    builder.append(subCategoryInfo);
                    builder.append("</li>");
                }
                builder.append("</ul>");
            }
        }
        return builder.toString();
    }

    public static boolean hasPermission(Category category) {
        List listOfUser = UserHelper.getAllGroupAndMembershipOfUser(null);
        if (!CommonUtils.isEmpty((String[])category.getModerators()) && org.exoplatform.faq.service.Utils.hasPermission(Arrays.asList(category.getModerators()), (List)listOfUser)) {
            return true;
        }
        if (!CommonUtils.isEmpty((String[])category.getUserPrivate())) {
            return org.exoplatform.faq.service.Utils.hasPermission(Arrays.asList(category.getUserPrivate()), (List)listOfUser);
        }
        return true;
    }

    public static Map<String, String> getQuestionLanguages(Set<String> langOfQuestion) {
        LocaleConfigService configService = (LocaleConfigService)CommonsUtils.getService(LocaleConfigService.class);
        HashMap<String, String> datas = new HashMap<String, String>();
        Locale current = WebuiRequestContext.getCurrentInstance().getLocale();
        for (LocaleConfig local : configService.getLocalConfigs()) {
            Locale getLocal = local.getLocale();
            if (!langOfQuestion.contains(getLocal.getDisplayLanguage())) continue;
            datas.put(getLocal.getDisplayLanguage(), getLocal.getDisplayLanguage(current));
        }
        return datas;
    }
}

