/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.webui;

import java.io.Writer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.input.UICheckBoxInput;

public class UIForumCheckBoxInput
extends UICheckBoxInput {
    private String label;
    private String onchange_;
    private boolean isInTable = false;

    public UIForumCheckBoxInput(String name, String bindingExpression, String label, Boolean value) {
        super(name, bindingExpression, value);
        this.label = label;
        this.isInTable = false;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isInTable() {
        return this.isInTable;
    }

    public UIForumCheckBoxInput setInTable(boolean isInTable) {
        this.isInTable = isInTable;
        return this;
    }

    public void setOnChange(String onchange) {
        super.setOnChange(onchange);
        this.onchange_ = onchange;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        if (this.isInTable) {
            w.write("<tr>\n");
            w.write("  <td>\n");
        }
        w.write("<span class=\"uiCheckbox\">\n");
        w.write("<input type=\"checkbox\" class=\"checkbox\" name=\"");
        w.write(this.name);
        w.write("\" id=\"");
        w.write(this.name);
        w.write("\"");
        if (this.onchange_ != null) {
            UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
            w.append(" onclick=\"").append(this.renderOnChangeEvent(uiForm)).append("\"");
        }
        if (this.isChecked()) {
            w.write(" checked");
        }
        if (this.isDisabled()) {
            w.write(" disabled");
        }
        this.renderHTMLAttributes(w);
        w.write("/>");
        w.write("<span>" + this.label + "</span>\n");
        w.write("</span>");
        if (this.isMandatory()) {
            w.write(" *");
        }
        if (this.isInTable) {
            w.write("  </td>\n");
            w.write("</tr>\n");
        }
    }
}

