/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.rss;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.w3c.dom.Document;

public class RSS {
    private static final Log LOG = ExoLogger.getLogger(RSS.class);
    protected static final String CONTENT_PROPERTY = "exo:content".intern();
    protected static final String RSS_NODE_NAME = "ks.rss".intern();
    protected static final String RSS_2_0 = "rss_2.0".intern();
    public static final String PLAIN_TEXT = "text/plain".intern();
    public static final String DEFAULT_FEED_LINK = "http://www.exoplatform.com".intern();
    private String fileName;
    private Node itemNode;

    public RSS(Node node) {
        this.itemNode = node;
    }

    public static String getRSSLink(String appType, String portalName, String objectId) {
        return "/" + PortalContainer.getInstance().getRestContextName() + "/ks/" + appType + "/rss/" + objectId;
    }

    public static String getUserRSSLink(String apptype, String userId) {
        return "/" + PortalContainer.getInstance().getRestContextName() + "/ks/" + apptype + "/rss/user/" + userId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public InputStream getContent() {
        try {
            return this.getFeedNode().getProperty(CONTENT_PROPERTY).getValue().getStream();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get feed content ", e);
        }
    }

    public void setContent(InputStream is) {
        try {
            this.getFeedNode().setProperty(CONTENT_PROPERTY, is);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get feed content ", e);
        }
    }

    private Node getFeedNode() throws Exception {
        try {
            return this.itemNode.getNode(RSS_NODE_NAME);
        }
        catch (Exception e) {
            return this.itemNode.addNode(RSS_NODE_NAME, "exo:forumRSS");
        }
    }

    public SyndFeed read() {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            InputStream inputStream = this.getContent();
            Document doc = docBuilder.parse(inputStream);
            doc.getDocumentElement().normalize();
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to read RSS feed");
            throw new RuntimeException(e);
        }
    }

    public SyndFeed removeEntry(String uri) {
        SyndFeed feed = this.read();
        List entries = feed.getEntries();
        if (uri != null && uri.trim().length() > 0) {
            for (SyndEntry syndEntry : entries) {
                if (!syndEntry.getUri().equals(uri)) continue;
                entries.remove(syndEntry);
                break;
            }
        }
        feed.setEntries(entries);
        return feed;
    }

    public SyndFeed addEntry(SyndEntry newEntry) {
        SyndFeed feed = this.read();
        List entries = feed.getEntries();
        if (newEntry != null) {
            entries.add(0, newEntry);
        }
        feed.setEntries(entries);
        return feed;
    }

    public void saveFeed(SyndFeed feed, String rssNodeType) {
        try {
            boolean isNew = false;
            try {
                this.itemNode.getNode(RSS_NODE_NAME);
            }
            catch (PathNotFoundException pnfe) {
                LOG.debug((Object)("Feed node not found for " + this.itemNode.getName() + " creating..."));
                this.itemNode.addNode(RSS_NODE_NAME, rssNodeType);
                isNew = true;
            }
            SyndFeedOutput output = new SyndFeedOutput();
            this.setContent(new ByteArrayInputStream(output.outputString(feed).getBytes()));
            if (isNew) {
                this.itemNode.getSession().save();
            } else {
                this.itemNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save feed content", (Throwable)e);
        }
    }

    public boolean feedExists() {
        try {
            return this.itemNode.hasNode(RSS_NODE_NAME);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static SyndFeed createNewFeed(String title, Date pubDate) {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setLink(DEFAULT_FEED_LINK);
        feed.setFeedType(RSS_2_0);
        feed.setTitle(title);
        feed.setPublishedDate(pubDate);
        feed.setDescription(" ");
        return feed;
    }

    public static SyndEntry createNewEntry(String uri, String title, String link, List<String> listContent, SyndContent description, Date pubDate, String author) {
        SyndEntryImpl entry = new SyndEntryImpl();
        entry.setUri(uri);
        entry.setTitle(title);
        entry.setLink(link + uri);
        entry.setContributors(listContent);
        entry.setDescription(description);
        entry.setPublishedDate(pubDate);
        entry.setAuthor(author);
        return entry;
    }

    public Node getItemNode() {
        return this.itemNode;
    }

    public void setItemNode(Node itemNode) {
        try {
            Node rssNode = itemNode.getNode(RSS_NODE_NAME);
            if (!rssNode.hasProperty(CONTENT_PROPERTY)) {
                throw new IllegalArgumentException("Node does not have an RSS feed child");
            }
            this.setContent(rssNode.getProperty(CONTENT_PROPERTY).getValue().getStream());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set item node for RSS", e);
        }
        this.itemNode = itemNode;
    }
}

