/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;

public class UserHelper {
    private static final int LIMIT_THRESHOLD = 200;

    public static OrganizationService getOrganizationService() {
        return CommonUtils.getComponent(OrganizationService.class);
    }

    public static UserHandler getUserHandler() {
        return UserHelper.getOrganizationService().getUserHandler();
    }

    public static GroupHandler getGroupHandler() {
        return UserHelper.getOrganizationService().getGroupHandler();
    }

    public static MembershipHandler getMembershipHandler() {
        return UserHelper.getOrganizationService().getMembershipHandler();
    }

    public static List<Group> getAllGroup() throws Exception {
        return Collections.unmodifiableList((List)UserHelper.getGroupHandler().getAllGroups());
    }

    public static String checkValueUser(String values) throws Exception {
        StringBuilder errorUser = new StringBuilder();
        if (values != null && values.trim().length() > 0) {
            String[] userIds;
            for (String str : userIds = values.split(",")) {
                if ((str = str.trim()).indexOf("$") >= 0) {
                    str = str.replace("$", "&#36");
                }
                if (str.indexOf("/") >= 0) {
                    if (UserHelper.hasGroupIdAndMembershipId(str)) continue;
                    if (errorUser.length() == 0) {
                        errorUser.append(str);
                        continue;
                    }
                    errorUser.append(", ").append(str);
                    continue;
                }
                if (UserHelper.getUserHandler().findUserByName(str, UserStatus.ENABLED) != null) continue;
                if (errorUser.length() == 0) {
                    errorUser.append(str);
                    continue;
                }
                errorUser.append(", ").append(str);
            }
        }
        return errorUser.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasGroupIdAndMembershipId(String str) throws Exception {
        if (str.indexOf(":") >= 0) {
            String[] array = str.split(":");
            try {
                UserHelper.getGroupHandler().findGroupById(array[1]).getId();
            }
            catch (Exception e) {
                return false;
            }
            if (array[0].length() == 1 && array[0].charAt(0) == '*') {
                return true;
            }
            if (array[0].length() <= 0) return false;
            if (UserHelper.getOrganizationService().getMembershipTypeHandler().findMembershipType(array[0]) != null) return true;
            return false;
        }
        try {
            UserHelper.getGroupHandler().findGroupById(str).getId();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasUserInGroup(String groupId, String userId) {
        try {
            return UserHelper.matchGroup(UserHelper.getMembershipHandler(), groupId, userId);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ListAccess<User> getUserPageListByGroupId(String groupId) throws Exception {
        return UserHelper.getUserHandler().findUsersByGroupId(groupId);
    }

    public static User getUserByUserId(String userId) throws Exception {
        return UserHelper.getUserHandler().findUserByName(userId);
    }

    public static boolean isDisabledUser(String userName) {
        try {
            User user = UserHelper.getUserByUserId(userName);
            return user == null || !user.isEnabled();
        }
        catch (Exception e) {
            return true;
        }
    }

    public static String[] getUserGroups() throws Exception {
        ConversationState state = ConversationState.getCurrent();
        Set groups = state.getIdentity().getGroups();
        String[] groupIds = groups.toArray(new String[groups.size()]);
        return groupIds;
    }

    public static List<String> getAllGroupId() throws Exception {
        ArrayList<String> grIds = new ArrayList<String>();
        for (Group gr : UserHelper.getAllGroup()) {
            grIds.add(gr.getId());
        }
        return grIds;
    }

    public static List<Group> findGroups(Group group) throws Exception {
        return (List)UserHelper.getGroupHandler().findGroups(group);
    }

    public static boolean isAnonim() {
        String userId = UserHelper.getCurrentUser();
        return userId == null;
    }

    public static Collection<Membership> findMembershipsByUser(String userId) {
        try {
            return UserHelper.getMembershipHandler().findMembershipsByUser(userId);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static List<String> getAllGroupAndMembershipOfUser(String userId) {
        ArrayList<String> listOfUser;
        block3: {
            block2: {
                listOfUser = new ArrayList<String>();
                if (userId != null && !userId.equals(UserHelper.getCurrentUser())) break block2;
                ConversationState conversionState = ConversationState.getCurrent();
                Identity identity = conversionState.getIdentity();
                userId = identity.getUserId();
                if (userId == null) break block3;
                listOfUser.add(userId);
                for (MembershipEntry membership : identity.getMemberships()) {
                    listOfUser.add(membership.getGroup());
                    listOfUser.add(membership.getMembershipType() + ":" + membership.getGroup());
                }
                break block3;
            }
            listOfUser.add(userId);
            Collection<Membership> memberships = UserHelper.findMembershipsByUser(userId);
            for (Membership membership : memberships) {
                listOfUser.add(membership.getGroupId());
                listOfUser.add(membership.getMembershipType() + ":" + membership.getGroupId());
            }
        }
        return listOfUser;
    }

    public static String getEmailUser(String userName) throws Exception {
        User user = UserHelper.getUserHandler().findUserByName(userName);
        String email = user.getEmail();
        return email;
    }

    public static String getCurrentUser() {
        try {
            return Util.getPortalRequestContext().getRemoteUser();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getDisplayNameOfOwner(String owner) throws Exception {
        if (CommonUtils.isEmpty(owner)) {
            return "";
        }
        if (UserHelper.hasGroupIdAndMembershipId(owner)) {
            Group group;
            if (owner.contains(":")) {
                String membership = owner.substring(0, owner.indexOf(":"));
                String groupId = owner.substring(membership.length() + 1);
                Group group2 = UserHelper.getGroupHandler().findGroupById(groupId);
                if (group2 != null) {
                    return membership + " in " + group2.getGroupName();
                }
            }
            return (group = UserHelper.getGroupHandler().findGroupById(owner)) != null ? group.getGroupName() : "";
        }
        User user = UserHelper.getUserHandler().findUserByName(owner, UserStatus.ANY);
        if (user != null) {
            String displayName = user.getDisplayName();
            if (CommonUtils.isEmpty(displayName) || owner.equals(displayName)) {
                displayName = user.getFirstName() + " " + user.getLastName();
            }
            return displayName;
        }
        return "";
    }

    private static boolean matchGroup(MembershipHandler memberShipHandler, String groupId, String userId) throws Exception {
        return memberShipHandler.findMembershipsByUserAndGroup(userId, groupId).size() > 0;
    }

    private static ListAccess<User> searchUserByQuery(UserFilter userFilter) throws Exception {
        Query q = UserHelper.queryFilter(userFilter);
        if (q.isEmpty()) {
            return UserHelper.getUserHandler().findAllUsers();
        }
        return UserHelper.getUserHandler().findUsersByQuery(q);
    }

    public static ListAccess<User> searchUser(UserFilter userFilter) throws Exception {
        ListAccessImpl listUsers = null;
        String groupId = userFilter.getGroupId();
        if (!CommonUtils.isEmpty(groupId)) {
            listUsers = UserHelper.getUserHandler().findUsersByGroupId(groupId);
            if (CommonUtils.isEmpty(userFilter.getKeyword())) {
                return listUsers;
            }
            List<Object> results = new ArrayList();
            if (listUsers.getSize() > 200) {
                listUsers = UserHelper.searchUserByQuery(userFilter);
                results = UserHelper.filter(userFilter, listUsers, true);
            } else {
                results = UserHelper.filter(userFilter, listUsers, false);
            }
            listUsers = new ListAccessImpl(User.class, results);
        } else {
            listUsers = UserHelper.searchUserByQuery(userFilter);
        }
        return listUsers;
    }

    public static List<User> filter(UserFilter userFilter, ListAccess<User> listUsers, boolean matchGroup) throws Exception {
        ArrayList<User> results = new ArrayList<User>();
        MembershipHandler memberShipHandler = UserHelper.getMembershipHandler();
        for (User user : (User[])listUsers.load(0, listUsers.getSize())) {
            if ((!matchGroup || !UserHelper.matchGroup(memberShipHandler, userFilter.getGroupId(), user.getUserName())) && (matchGroup || !UserHelper.matchUser(userFilter, user))) continue;
            results.add(user);
        }
        return results;
    }

    public static boolean matchUser(UserFilter userFilter, User user) {
        if (user == null) {
            return false;
        }
        if (FilterType.USER_NAME == userFilter.getFilterType() && StringUtils.containsIgnoreCase((String)user.getUserName(), (String)userFilter.getKeyword())) {
            return true;
        }
        if (FilterType.LAST_NAME == userFilter.getFilterType() && StringUtils.containsIgnoreCase((String)user.getLastName(), (String)userFilter.getKeyword())) {
            return true;
        }
        if (FilterType.FIRST_NAME == userFilter.getFilterType() && StringUtils.containsIgnoreCase((String)user.getFirstName(), (String)userFilter.getKeyword())) {
            return true;
        }
        return FilterType.EMAIL == userFilter.getFilterType() && StringUtils.containsIgnoreCase((String)user.getEmail(), (String)userFilter.getKeyword());
    }

    public static Query queryFilter(UserFilter userFilter) {
        Query q = new Query();
        String keyword = userFilter.getKeyword();
        if (!CommonUtils.isEmpty(keyword) && userFilter.getFilterType() != null) {
            if (keyword.indexOf("*") < 0) {
                if (keyword.charAt(0) != '*') {
                    keyword = "*" + keyword;
                }
                if (keyword.charAt(keyword.length() - 1) != '*') {
                    keyword = keyword + "*";
                }
            }
            keyword = keyword.replace('?', '_');
            if (FilterType.USER_NAME == userFilter.getFilterType()) {
                q.setUserName(keyword);
            }
            if (FilterType.LAST_NAME == userFilter.getFilterType()) {
                q.setLastName(keyword);
            }
            if (FilterType.FIRST_NAME == userFilter.getFilterType()) {
                q.setFirstName(keyword);
            }
            if (FilterType.EMAIL == userFilter.getFilterType()) {
                q.setEmail(keyword);
            }
        }
        return q;
    }

    public static class UserFilter {
        private String keyword;
        private FilterType filterType;
        private String groupId;

        public UserFilter(String keyword, FilterType filterType) {
            this.keyword = keyword;
            this.filterType = filterType;
        }

        public UserFilter setGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public FilterType getFilterType() {
            return this.filterType;
        }

        public String getGroupId() {
            return this.groupId;
        }
    }

    public static enum FilterType {
        USER_NAME("userName"),
        LAST_NAME("lastName"),
        FIRST_NAME("firstName"),
        EMAIL("email");

        String name;

        private FilterType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static FilterType getType(String name) {
            for (FilterType type : FilterType.values()) {
                if (!type.getName().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }
    }
}

