/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.bbcode.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.bbcode.api.BBCode;
import org.exoplatform.forum.bbcode.core.BuiltinBBCodeProvider;
import org.exoplatform.forum.bbcode.spi.BBCodeData;
import org.exoplatform.forum.bbcode.spi.BBCodeProvider;
import org.exoplatform.forum.common.TransformHTML;
import org.exoplatform.forum.rendering.api.Renderer;
import org.exoplatform.forum.rendering.core.SupportedSyntaxes;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.rendering.RenderingService;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxType;

public class BBCodeRenderer
implements Renderer {
    public static final String BBCODE_SYNTAX_ID = "bbcode";
    protected BBCodeProvider bbCodeProvider = new BuiltinBBCodeProvider();
    private static final Log log = ExoLogger.getLogger(BBCodeRenderer.class);
    private static Map<String, String> dataStyleList = new HashMap<String, String>();

    public String getSyntax() {
        return SupportedSyntaxes.bbcode.name();
    }

    public String render(String s) {
        for (BBCode bbcode : this.getBbcodes()) {
            s = this.processReplace(s, bbcode);
        }
        return s;
    }

    public String processReplace(String s, BBCode bbcode) {
        String bbc = bbcode.getTagName();
        if (bbc.equals("URL")) {
            s = StringUtils.replace((String)s, (String)"[link", (String)"[URL");
            s = StringUtils.replace((String)s, (String)"[/link]", (String)"[/URL]");
            s = StringUtils.replace((String)s, (String)"[LINK", (String)"[URL");
            s = StringUtils.replace((String)s, (String)"[/LINK]", (String)"[/URL]");
        }
        s = !bbc.equals("LIST") ? (Boolean.valueOf(bbcode.isOption()).booleanValue() ? this.processOptionedTag(s, bbcode) : this.processTag(s, bbcode)) : this.processList(s);
        return s;
    }

    String processTag(String s, BBCode bbcode) {
        String bbc = bbcode.getTagName();
        int lastIndex = 0;
        int tagIndex = 0;
        String start = "[" + bbc + "]";
        String end = "[/" + bbc + "]";
        s = StringUtils.replace((String)s, (String)start.toLowerCase(), (String)start);
        s = StringUtils.replace((String)s, (String)end.toLowerCase(), (String)end);
        while ((tagIndex = s.indexOf(start, lastIndex)) != -1) {
            lastIndex = tagIndex + 1;
            try {
                String param;
                String str;
                block6: {
                    int clsIndex = s.indexOf(end, tagIndex);
                    str = s.substring(tagIndex + start.length(), clsIndex);
                    if ("WIKI".equals(bbc)) {
                        String sourceSyntax = Syntax.CONFLUENCE_1_0.toIdString();
                        RenderingService renderingService = (RenderingService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RenderingService.class);
                        param = TransformHTML.getPlainText((String)str);
                        try {
                            param = renderingService.render(param, sourceSyntax, Syntax.XHTML_1_0.toIdString(), false);
                            param = new StringBuffer("<div class=\"uiWikiPortlet\">").append(param).append("</div>").toString();
                            break block6;
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    param = StringUtils.replace((String)bbcode.getReplacement(), (String)"{param}", (String)str);
                }
                s = StringUtils.replace((String)s, (String)(start + str + end), (String)param);
            }
            catch (Exception e) {}
        }
        return s;
    }

    String processOptionedTag(String markup, BBCode bbcode) {
        String bbc = bbcode.getTagName();
        int lastIndex = 0;
        int tagIndex = 0;
        String start = "[" + bbc + "=";
        String end = "[/" + bbc + "]";
        markup = StringUtils.replace((String)markup, (String)start.toLowerCase(), (String)start);
        markup = StringUtils.replace((String)markup, (String)end.toLowerCase(), (String)end);
        while ((tagIndex = markup.indexOf(start, lastIndex)) != -1) {
            lastIndex = tagIndex + 1;
            try {
                String param;
                String str;
                block17: {
                    int clsIndex = markup.indexOf(end, tagIndex);
                    str = markup.substring(tagIndex + start.length(), clsIndex);
                    String option = str.substring(0, str.indexOf("]"));
                    if (option.indexOf("+") == 0) {
                        option = option.replaceFirst("\\+", "");
                    }
                    if (option.indexOf("\"") == 0) {
                        option = option.replaceAll("\"", "");
                    }
                    if (option.indexOf("'") == 0) {
                        option = option.replaceAll("'", "");
                    }
                    if (option.indexOf("&quot;") == 0) {
                        option = option.replaceAll("&quot;", "");
                    }
                    option = option.trim();
                    param = str.substring(str.indexOf("]") + 1);
                    while (bbc.equals("CODE") && param.indexOf("<br") >= 0) {
                        param = param.replaceAll("<br\\s*\\/?>", "\n");
                    }
                    while (bbc.equals("CODE") && param.indexOf("<p>") >= 0 && param.indexOf("</p>") >= 0) {
                        param = StringUtils.replace((String)param, (String)"<p>", (String)"");
                        param = StringUtils.replace((String)param, (String)"</p>", (String)"\n");
                    }
                    if ("WIKI".equals(bbc)) {
                        String sourceSyntax = Syntax.CONFLUENCE_1_0.toIdString();
                        option = option.toLowerCase();
                        if (SyntaxType.XWIKI.getId().equals(option)) {
                            sourceSyntax = Syntax.XWIKI_2_0.toIdString();
                        } else if (SyntaxType.CREOLE.getId().equals(option)) {
                            sourceSyntax = Syntax.CREOLE_1_0.toIdString();
                        } else if (SyntaxType.MEDIAWIKI.getId().equals(option)) {
                            sourceSyntax = Syntax.MEDIAWIKI_1_0.toIdString();
                        }
                        RenderingService renderingService = (RenderingService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RenderingService.class);
                        param = TransformHTML.getPlainText((String)param);
                        try {
                            param = renderingService.render(param, sourceSyntax, Syntax.XHTML_1_0.toIdString(), false);
                            param = new StringBuffer("<div class=\"uiWikiPortlet\">").append(param).append("</div>").toString();
                            break block17;
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    param = StringUtils.replace((String)bbcode.getReplacement(), (String)"{param}", (String)param);
                    param = StringUtils.replace((String)param, (String)"{option}", (String)option);
                }
                markup = StringUtils.replace((String)markup, (String)(start + str + end), (String)param);
            }
            catch (Exception e) {}
        }
        return markup;
    }

    String processList(String s) {
        String str;
        int clsIndex;
        int lastIndex = 0;
        int tagIndex = 0;
        s = StringUtils.replace((String)s, (String)"[LIST", (String)"[list");
        s = StringUtils.replace((String)s, (String)"[/LIST]", (String)"[/list]");
        while ((tagIndex = s.indexOf("[list]", lastIndex)) != -1) {
            lastIndex = tagIndex + 1;
            try {
                clsIndex = s.indexOf("[/list]", tagIndex);
                str = s.substring(tagIndex + 6, clsIndex);
                String str_ = "";
                str_ = StringUtils.replaceOnce((String)str, (String)"[*]", (String)"<li>");
                str_ = StringUtils.replace((String)str_, (String)"[*]", (String)"</li><li>");
                if (str_.lastIndexOf("</li><li>") > 0) {
                    str_ = str_ + "</li>";
                }
                str_ = this.cleanHTMLTagInTagList(str_);
                str_ = StringUtils.replace((String)str_, (String)"<li>", (String)("<li " + this.getStyleList("o") + ">"));
                s = StringUtils.replace((String)s, (String)("[list]" + str + "[/list]"), (String)("<ul>" + str_ + "</ul>"));
            }
            catch (Exception e) {}
        }
        lastIndex = 0;
        tagIndex = 0;
        while ((tagIndex = s.indexOf("[list=", lastIndex)) != -1) {
            lastIndex = tagIndex + 1;
            try {
                clsIndex = s.indexOf("[/list]", tagIndex);
                String content = s.substring(tagIndex + 6, clsIndex);
                int clsType = content.indexOf("]");
                String type = content.substring(0, clsType);
                type = type.replaceAll("\"", "").replaceAll("'", "");
                str = content.substring(clsType + 1);
                String str_ = "";
                str_ = StringUtils.replaceOnce((String)str, (String)"[*]", (String)"<li>");
                str_ = StringUtils.replace((String)str_, (String)"[*]", (String)"</li><li>");
                if (str_.lastIndexOf("</li><li>") > 0) {
                    str_ = str_ + "</li>";
                }
                str_ = this.cleanHTMLTagInTagList(str_);
                if (" 1 i I a A ".indexOf(type) > 0) {
                    str_ = StringUtils.replace((String)str_, (String)"<li>", (String)("<li " + this.getStyleList(type) + ">"));
                    s = StringUtils.replace((String)s, (String)("[list=" + content + "[/list]"), (String)("<ol type=\"" + type + "\">" + str_ + "</ol>"));
                    continue;
                }
                str_ = StringUtils.replace((String)str_, (String)"<li>", (String)("<li style=\"list-style-type:" + type + ";\">"));
                s = StringUtils.replace((String)s, (String)("[list=" + content + "[/list]"), (String)("<ul>" + str_ + "</ul>"));
            }
            catch (Exception e) {}
        }
        return s;
    }

    private String getStyleList(String type) {
        if (dataStyleList.isEmpty()) {
            this.buildStyleList();
        }
        return dataStyleList.get(type);
    }

    private void buildStyleList() {
        dataStyleList.put("o", "style=\"list-style-type:disc;\"");
        dataStyleList.put("1", "style=\"list-style-type:decimal;\"");
        dataStyleList.put("i", "style=\"list-style-type:lower-roman;\"");
        dataStyleList.put("I", "style=\"list-style-type:upper-roman;\"");
        dataStyleList.put("a", "style=\"list-style-type:lower-alpha;\"");
        dataStyleList.put("A", "style=\"list-style-type:upper-alpha;\"");
    }

    public String cleanHTMLTagInTagList(String str) {
        str = str.replaceAll("<br.*?>", "");
        str = str.replaceAll("</?p>", "");
        str = str.replaceAll("</div>", "");
        str = str.replaceAll("<div.*?>", "");
        return str;
    }

    public List<BBCode> getBbcodes() {
        ArrayList<BBCode> result = new ArrayList<BBCode>();
        Collection<String> supported = this.getBbCodeProvider().getSupportedBBCodes();
        if (supported == null) {
            log.warn((Object)"No BBCode supported by this renderer");
            return result;
        }
        for (String tag : supported) {
            result.add(this.getBbCodeProvider().getBBCode(tag));
        }
        return result;
    }

    protected List<BBCode> convert(List<BBCodeData> bbc) {
        ArrayList<BBCode> bbcodes = new ArrayList<BBCode>();
        for (BBCodeData bbCodeData : bbc) {
            BBCode bbCode = new BBCode();
            bbCode.setActive(Boolean.valueOf(bbCodeData.getIsActive()));
            bbCode.setDescription(bbCodeData.getDescription());
            bbCode.setExample(bbCodeData.getExample());
            bbCode.setOption(Boolean.valueOf(bbCodeData.getIsOption()));
            bbCode.setReplacement(bbCodeData.getReplacement());
            bbCode.setTagName(bbCodeData.getTagName());
            bbcodes.add(bbCode);
        }
        return bbcodes;
    }

    public BBCodeProvider getBbCodeProvider() {
        return this.bbCodeProvider;
    }

    public void setBbCodeProvider(BBCodeProvider bbCodeProvider) {
        this.bbCodeProvider = bbCodeProvider;
    }

    public String renderExample(String s, BBCode bbco) {
        ArrayList<BBCode> bbcodes = new ArrayList<BBCode>();
        bbcodes.add(bbco);
        bbcodes.addAll(this.getBbcodes());
        for (BBCode bbcode : bbcodes) {
            if (bbcode.getId().equals(bbco.getId())) {
                s = this.processReplace(s, bbco);
                continue;
            }
            s = this.processReplace(s, bbcode);
        }
        return s;
    }
}

