/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.bbcode.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.forum.bbcode.api.BBCode;
import org.exoplatform.forum.bbcode.api.BBCodeService;
import org.exoplatform.forum.bbcode.spi.BBCodePlugin;

public class MemoryBBCodeService
implements BBCodeService {
    private Map<String, BBCode> bbcodes = new HashMap<String, BBCode>();

    @Override
    public void delete(String bbcodeId) throws Exception {
        this.bbcodes.remove(bbcodeId);
    }

    @Override
    public BBCode findById(String bbcodeId) throws Exception {
        return this.bbcodes.get(bbcodeId);
    }

    @Override
    public List<String> getActive() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (BBCode bbCode : this.bbcodes.values()) {
            if (!bbCode.isActive()) continue;
            result.add(bbCode.getId());
        }
        return result;
    }

    @Override
    public List<BBCode> getAll() throws Exception {
        return new ArrayList<BBCode>(this.bbcodes.values());
    }

    @Override
    public void registerBBCodePlugin(BBCodePlugin plugin) throws Exception {
        throw new UnsupportedOperationException("registering a BBCode plugin is not supported by " + this.getClass());
    }

    @Override
    public void save(List<BBCode> bbcodes) throws Exception {
        for (BBCode bbCode : bbcodes) {
            this.addBBCode(bbCode);
        }
    }

    public void addBBCode(BBCode code) {
        code.setId(code.getTagName() + (code.isOption() ? "=" : ""));
        this.bbcodes.put(code.getId(), code);
    }
}

