/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.bbcode.core;

import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.exoplatform.forum.bbcode.api.BBCode;
import org.exoplatform.forum.bbcode.core.BBCodeRenderer;
import org.exoplatform.forum.bbcode.core.BuiltinBBCodeProvider;
import org.exoplatform.forum.bbcode.spi.BBCodeData;
import org.exoplatform.forum.bbcode.spi.BBCodeProvider;

public class TestBBCodeRenderer
extends TestCase {
    public void testProcessTag() {
        BBCodeRenderer renderer = new BBCodeRenderer();
        BBCode bbcode = this.createBBCode("I", "<i>{param}</i>");
        String actual = renderer.processTag("[I]italic[/I]", bbcode);
        TestBBCodeRenderer.assertEquals((String)"<i>italic</i>", (String)actual);
        actual = renderer.processTag("[I]foo[/I] ... [I]bar[/I]", bbcode);
        TestBBCodeRenderer.assertEquals((String)"<i>foo</i> ... <i>bar</i>", (String)actual);
    }

    public void testRenderLinkAlias() {
        BBCodeRenderer renderer = new BBCodeRenderer();
        renderer.setBbCodeProvider(new BBCodeProvider(){

            public Collection<String> getSupportedBBCodes() {
                return Arrays.asList("URL");
            }

            public BBCode getBBCode(String tagName) {
                BBCode bbcode = new BBCode();
                bbcode.setTagName("URL");
                bbcode.setReplacement("<a href='{option}'>{param}</a>");
                bbcode.setOption(true);
                return bbcode;
            }
        });
        String actual = renderer.render("[link=http://www.example.org]example[/link]");
        TestBBCodeRenderer.assertEquals((String)"<a href='http://www.example.org'>example</a>", (String)actual);
    }

    public void testProcessOptionedTag() {
        BBCodeRenderer renderer = new BBCodeRenderer();
        BBCode bbc = this.createOptionedBBCode("email", "<a href='mailto:{option}'>{param}</a>");
        String markup = "[email=demo@example.com]Click Here to Email me[/email]";
        TestBBCodeRenderer.assertEquals((String)"<a href='mailto:demo@example.com'>Click Here to Email me</a>", (String)renderer.processOptionedTag(markup, bbc));
        bbc = this.createOptionedBBCode("foo", "foo:{option}>{param}");
        markup = "[foo=bar]blah[/foo] ... [foo=joe]blih[/foo]";
        TestBBCodeRenderer.assertEquals((String)"foo:bar>blah ... foo:joe>blih", (String)renderer.processOptionedTag(markup, bbc));
        bbc = this.createOptionedBBCode("size", "<font size='{option}'>{param}</font>");
        markup = "[size=+2]foo[/size]";
        TestBBCodeRenderer.assertEquals((String)"<font size='+2'>foo</font>", (String)renderer.processOptionedTag(markup, bbc));
        bbc = this.createOptionedBBCode("url", "<a href='{option}'>{param}</a>");
        markup = "[url=\"http://www.example.org\"]foo[/url]";
        TestBBCodeRenderer.assertEquals((String)"<a href='http://www.example.org'>foo</a>", (String)renderer.processOptionedTag(markup, bbc));
        bbc = this.createOptionedBBCode("url", "<a href='{option}'>{param}</a>");
        markup = "[url=&quot;http://www.example.org&quot;]foo[/url]";
        TestBBCodeRenderer.assertEquals((String)"<a href='http://www.example.org'>foo</a>", (String)renderer.processOptionedTag(markup, bbc));
    }

    private BBCode createOptionedBBCode(String tag, String replacement) {
        BBCode bbc = new BBCode();
        bbc.setTagName(tag);
        bbc.setOption(true);
        bbc.setReplacement(replacement);
        return bbc;
    }

    private BBCode createBBCode(String tag, String replacement) {
        BBCode bbc = new BBCode();
        bbc.setTagName(tag);
        bbc.setOption(false);
        bbc.setReplacement(replacement);
        return bbc;
    }

    public void testProcessList() {
        BBCodeData bbcode = new BBCodeData();
        bbcode.setTagName("list");
        bbcode.setIsOption("false");
        BBCodeRenderer renderer = new BBCodeRenderer();
        String actual = renderer.processList("[list][*]list item 1[*]list item 2[/list]");
        TestBBCodeRenderer.assertEquals((String)"<ul><li style=\"list-style-type:disc;\">list item 1</li><li style=\"list-style-type:disc;\">list item 2</li></ul>", (String)actual);
        bbcode.setIsOption("true");
        actual = renderer.processList("[list=1][*]list item 1[*]list item 2[/list]");
        String expected = "<ol type=\"1\"><li style=\"list-style-type:decimal;\">list item 1</li><li style=\"list-style-type:decimal;\">list item 2</li></ol>";
        TestBBCodeRenderer.assertEquals((String)expected, (String)actual);
        bbcode.setIsOption("true");
        actual = renderer.processList("[list=a][*]list item 1[*]list item 2[/list]");
        expected = "<ol type=\"a\"><li style=\"list-style-type:lower-alpha;\">list item 1</li><li style=\"list-style-type:lower-alpha;\">list item 2</li></ol>";
        TestBBCodeRenderer.assertEquals((String)expected, (String)actual);
    }

    public void testBuiltinBBCodes() {
        BBCodeRenderer renderer = new BBCodeRenderer();
        renderer.setBbCodeProvider((BBCodeProvider)new BuiltinBBCodeProvider());
        TestBBCodeRenderer.assertEquals((String)"<strong>param</strong>", (String)renderer.render("[B]param[/B]"));
        TestBBCodeRenderer.assertEquals((String)"<i>param</i>", (String)renderer.render("[I]param[/I]"));
        TestBBCodeRenderer.assertEquals((String)"<u>param</u>", (String)renderer.render("[U]param[/U]"));
        TestBBCodeRenderer.assertEquals((String)"<font color=\"blue\">param</font>", (String)renderer.render("[COLOR=blue]param[/COLOR]"));
        TestBBCodeRenderer.assertEquals((String)"<font face=\"courier\">param</font>", (String)renderer.render("[FONT=courier]param[/FONT]"));
        TestBBCodeRenderer.assertEquals((String)"<span class=\"highlighted\">param</span>", (String)renderer.render("[HIGHLIGHT]param[/HIGHLIGHT]"));
        TestBBCodeRenderer.assertEquals((String)"<div align=\"left\">param</div>", (String)renderer.render("[LEFT]param[/LEFT]"));
        TestBBCodeRenderer.assertEquals((String)"<div align=\"right\">param</div>", (String)renderer.render("[RIGHT]param[/RIGHT]"));
        TestBBCodeRenderer.assertEquals((String)"<div align=\"center\">param</div>", (String)renderer.render("[CENTER]param[/CENTER]"));
        TestBBCodeRenderer.assertEquals((String)"<div align=\"justify\">param</div>", (String)renderer.render("[JUSTIFY]param[/JUSTIFY]"));
        TestBBCodeRenderer.assertEquals((String)"<a href=\"mailto:param\">param</a>", (String)renderer.render("[EMAIL]param[/EMAIL]"));
        TestBBCodeRenderer.assertEquals((String)"<a href=\"mailto:option\">param</a>", (String)renderer.render("[EMAIL=option]param[/EMAIL]"));
        TestBBCodeRenderer.assertEquals((String)"<a target=\"_blank\" href=\"http://www.exoplatform.org\">http://www.exoplatform.org</a>", (String)renderer.render("[URL]http://www.exoplatform.org[/URL]"));
        TestBBCodeRenderer.assertEquals((String)"<a target=\"_blank\" href=\"http://www.exoplatform.org\">eXo</a>", (String)renderer.render("[URL=http://www.exoplatform.org]eXo[/URL]"));
        TestBBCodeRenderer.assertEquals((String)"<a href=\"http://www.exoplatform.org\">eXo</a>", (String)renderer.render("[GOTO=http://www.exoplatform.org]eXo[/GOTO]"));
        TestBBCodeRenderer.assertEquals((String)"<img border=\"0\" alt=\"param\" src=\"param\" class=\"inlineimg\"/>", (String)renderer.render("[IMG]param[/IMG]"));
        TestBBCodeRenderer.assertEquals((String)"<blockquote>param</blockquote>", (String)renderer.render("[QUOTE]param[/QUOTE]"));
        TestBBCodeRenderer.assertEquals((String)"<blockquote cite=\"author\">param</blockquote>", (String)renderer.render("[QUOTE=author]param[/QUOTE]"));
        TestBBCodeRenderer.assertEquals((String)"<span class=\"option\">param</span>", (String)renderer.render("[CSS=option]param[/CSS]"));
        TestBBCodeRenderer.assertEquals((String)"<font size=\"2\">param</font>", (String)renderer.render("[SIZE=2]param[/SIZE]"));
        TestBBCodeRenderer.assertEquals((String)"<font size=\"+2\">param</font>", (String)renderer.render("[SIZE=+2]param[/SIZE]"));
        TestBBCodeRenderer.assertEquals((String)"<font size=\"-2\">param</font>", (String)renderer.render("[SIZE=-2]param[/SIZE]"));
        String input = "[color=red \"onmouseover=\"(function(){document.write('I'm evil');}).call(this)\"]hello world[/color]";
        String expected = "<font color=\"red onmouseover=(function(){document.write(Im evil);}).call(this)\">hello world</font>";
        TestBBCodeRenderer.assertEquals((String)expected, (String)renderer.render(input));
        input = "[size=15\"onmouseover=\"(function(){document.write('I'm evil');}).call(this)\"]hello world[/size]";
        expected = "<font size=\"15onmouseover=(function(){document.write(Im evil);}).call(this)\">hello world</font>";
        TestBBCodeRenderer.assertEquals((String)expected, (String)renderer.render(input));
        input = "[url=http://example.com&quot;onmouseover=&quot;(function(){document.write(&#39;I&#39;m evil&#39;);}).call(this)&quot;]Example[/url]";
        expected = "<a target=\"_blank\" href=\"http://example.comonmouseover=(function(){document.write(&#39;I&#39;m evil&#39;);}).call(this)\">Example</a>";
        TestBBCodeRenderer.assertEquals((String)expected, (String)renderer.render(input));
    }

    public void testCleanHTMLTagInTagList() {
        BBCodeRenderer renderer = new BBCodeRenderer();
        String input = "dsad <br>fsd f <br/> sdfsjdf <br /> fsdfs f<div style=\"xxx\">fsfsdfdsf</div> fsdfsdf <p>fsdfsdf</p> fdsfsd";
        TestBBCodeRenderer.assertEquals((String)"dsad fsd f  sdfsjdf  fsdfs ffsfsdfdsf fsdfsdf fsdfsdf fdsfsd", (String)renderer.cleanHTMLTagInTagList(input));
    }
}

