/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.bbcode.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.forum.bbcode.api.BBCode;
import org.exoplatform.forum.bbcode.base.BaseBBcodeTestCase;
import org.exoplatform.forum.bbcode.spi.BBCodeData;
import org.exoplatform.forum.bbcode.spi.BBCodePlugin;

public class TestBBCodeServiceImpl
extends BaseBBcodeTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRegisterBBCodePlugin() throws Exception {
        BBCodePlugin plugin = new BBCodePlugin();
        plugin.setName("plugin1");
        this.bbcodeServiceImpl.registerBBCodePlugin(plugin);
        List plugins = this.bbcodeServiceImpl.getPlugins();
        TestBBCodeServiceImpl.assertEquals((int)1, (int)plugins.size());
        TestBBCodeServiceImpl.assertEquals((String)"plugin1", (String)((BBCodePlugin)plugins.get(0)).getName());
        BBCodePlugin plugin2 = new BBCodePlugin();
        plugin2.setName("plugin2");
        this.bbcodeServiceImpl.registerBBCodePlugin(plugin2);
        List plugins2 = this.bbcodeServiceImpl.getPlugins();
        TestBBCodeServiceImpl.assertEquals((String)"BBCode plugins list size was not incremented", (int)2, (int)plugins2.size());
        TestBBCodeServiceImpl.assertEquals((String)"plugin2", (String)((BBCodePlugin)plugins.get(1)).getName());
    }

    public void testInitDefaultBBCodes() throws Exception {
        BBCodePlugin plugin = new BBCodePlugin();
        plugin.setBbcodeData(Arrays.asList(new BBCodeData("foo", "bar", false, false)));
        this.bbcodeServiceImpl.registerBBCodePlugin(plugin);
        this.bbcodeServiceImpl.initDefaultBBCodes();
        String targetPath = this.bbcodesPath + "/foo";
        this.assertNodeExists(targetPath);
    }

    public void testSave() throws Exception {
        List<BBCode> bbcodes = Arrays.asList(this.createBBCode("foo", "replacement", "description", "example", false, false));
        this.bbcodeService.save(bbcodes);
        String targetPath = this.bbcodesPath + "/foo";
        this.assertNodeExists(targetPath);
        Node n = this.getNode(targetPath);
        TestBBCodeServiceImpl.assertEquals((String)"foo", (String)n.getProperty("exo:tagName").getString());
        TestBBCodeServiceImpl.assertEquals((String)"replacement", (String)n.getProperty("exo:replacement").getString());
        TestBBCodeServiceImpl.assertEquals((String)"description", (String)n.getProperty("exo:description").getString());
        TestBBCodeServiceImpl.assertEquals((String)"example", (String)n.getProperty("exo:example").getString());
        TestBBCodeServiceImpl.assertEquals((boolean)false, (boolean)n.getProperty("exo:isOption").getBoolean());
        TestBBCodeServiceImpl.assertEquals((boolean)false, (boolean)n.getProperty("exo:isActive").getBoolean());
        n.getSession().logout();
    }

    public void testGetAll() throws Exception {
        ArrayList<BBCode> bbcodes = new ArrayList<BBCode>();
        bbcodes.add(this.createBBCode("foo", "replacement", "description", "example", false, true));
        bbcodes.add(this.createBBCode("foo", "replacement", "description", "example", true, false));
        bbcodes.add(this.createBBCode("foo2", "replacement", "description", "example", false, true));
        bbcodes.add(this.createBBCode("foo3", "replacement", "description", "example", false, true));
        bbcodes.add(this.createBBCode("foo4", "replacement", "description", "example", false, true));
        this.bbcodeService.save(bbcodes);
        List actual = this.bbcodeService.getAll();
        TestBBCodeServiceImpl.assertEquals((int)bbcodes.size(), (int)actual.size());
    }

    public void testGetActive() throws Exception {
        ArrayList<BBCode> bbcodes = new ArrayList<BBCode>();
        bbcodes.add(this.createBBCode("foo", "replacement", "description", "example", false, true));
        bbcodes.add(this.createBBCode("foo", "replacement", "description", "example", true, false));
        bbcodes.add(this.createBBCode("foo2", "replacement", "description", "example", true, true));
        bbcodes.add(this.createBBCode("foo3", "replacement", "description", "example", false, true));
        bbcodes.add(this.createBBCode("foo4", "replacement", "description", "example", false, true));
        this.bbcodeService.save(bbcodes);
        List actual = this.bbcodeService.getActive();
        TestBBCodeServiceImpl.assertEquals((int)(bbcodes.size() - 1), (int)actual.size());
        this.assertContains(actual, "foo", "foo2=", "foo3", "foo4");
    }

    public void testFindById() throws Exception {
        List<BBCode> bbcodes = Arrays.asList(this.createBBCode("foo", "replacement", "description", "example", true, true));
        this.bbcodeService.save(bbcodes);
        this.assertNodeExists(this.bbcodesPath + "/foo=");
        BBCode actual = this.bbcodeServiceImpl.findById("foo=");
        TestBBCodeServiceImpl.assertNotNull((Object)actual);
        TestBBCodeServiceImpl.assertEquals((String)"foo", (String)actual.getTagName());
        TestBBCodeServiceImpl.assertEquals((String)"replacement", (String)actual.getReplacement());
        TestBBCodeServiceImpl.assertEquals((String)"description", (String)actual.getDescription());
        TestBBCodeServiceImpl.assertEquals((String)"example", (String)actual.getExample());
        TestBBCodeServiceImpl.assertEquals((boolean)true, (boolean)actual.isOption());
        TestBBCodeServiceImpl.assertEquals((boolean)true, (boolean)actual.isActive());
    }

    public void testDelete() throws Exception {
        List<BBCode> bbcodes = Arrays.asList(this.createBBCode("foo", "replacement", "description", "example", false, false));
        this.bbcodeService.save(bbcodes);
        String targetPath = this.bbcodesPath + "/foo";
        this.assertNodeExists(targetPath);
        this.bbcodeService.delete("foo");
        this.assertNodeNotExists(targetPath);
    }
}

