/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.bbcode.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.forum.bbcode.api.BBCode;
import org.exoplatform.forum.bbcode.base.BaseBBcodeTestCase;
import org.exoplatform.forum.bbcode.core.cache.CachedBBCodeService;
import org.exoplatform.services.cache.CacheService;
import org.junit.Test;

public class TestBBcodeCacheService
extends BaseBBcodeTestCase {
    private CachedBBCodeService cachedBBCodeService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        if (this.cachedBBCodeService == null) {
            CacheService service = this.getService(CacheService.class);
            this.cachedBBCodeService = new CachedBBCodeService(service, this.bbcodeServiceImpl);
            this.cachedBBCodeService.start();
        }
    }

    @Test
    public void testSave() throws Exception {
        List<BBCode> bbcodes = Arrays.asList(this.createBBCode("list", "replacement", "description", "example", false, false));
        this.cachedBBCodeService.save(bbcodes);
        String targetPath = this.bbcodesPath + "/list";
        this.assertNodeExists(targetPath);
        Node n = this.getNode(targetPath);
        TestBBcodeCacheService.assertEquals((String)"list", (String)n.getProperty("exo:tagName").getString());
        TestBBcodeCacheService.assertEquals((String)"replacement", (String)n.getProperty("exo:replacement").getString());
        TestBBcodeCacheService.assertEquals((String)"description", (String)n.getProperty("exo:description").getString());
        TestBBcodeCacheService.assertEquals((String)"example", (String)n.getProperty("exo:example").getString());
        TestBBcodeCacheService.assertEquals((boolean)false, (boolean)n.getProperty("exo:isOption").getBoolean());
        TestBBcodeCacheService.assertEquals((boolean)false, (boolean)n.getProperty("exo:isActive").getBoolean());
        n.getSession().logout();
    }

    @Test
    public void testGetAll() throws Exception {
        ArrayList<BBCode> bbcodes = new ArrayList<BBCode>();
        bbcodes.add(this.createBBCode("foo", "replacement", "description", "example", false, true));
        bbcodes.add(this.createBBCode("foo", "replacement", "description", "example", true, false));
        bbcodes.add(this.createBBCode("foo2", "replacement", "description", "example", false, true));
        bbcodes.add(this.createBBCode("foo3", "replacement", "description", "example", false, true));
        bbcodes.add(this.createBBCode("foo4", "replacement", "description", "example", false, true));
        this.cachedBBCodeService.save(bbcodes);
        List actual = this.cachedBBCodeService.getAll();
        TestBBcodeCacheService.assertEquals((int)bbcodes.size(), (int)actual.size());
    }

    @Test
    public void testGetActive() throws Exception {
        ArrayList<BBCode> bbcodes = new ArrayList<BBCode>();
        bbcodes.add(this.createBBCode("foo", "replacement", "description", "example", false, true));
        bbcodes.add(this.createBBCode("foo", "replacement", "description", "example", true, false));
        bbcodes.add(this.createBBCode("foo2", "replacement", "description", "example", true, true));
        bbcodes.add(this.createBBCode("foo3", "replacement", "description", "example", false, true));
        bbcodes.add(this.createBBCode("foo4", "replacement", "description", "example", false, true));
        this.cachedBBCodeService.save(bbcodes);
        List actual = this.cachedBBCodeService.getActive();
        TestBBcodeCacheService.assertEquals((int)(bbcodes.size() - 1), (int)actual.size());
        this.assertContains(actual, "foo", "foo2=", "foo3", "foo4");
    }

    @Test
    public void testFindById() throws Exception {
        List<BBCode> bbcodes = Arrays.asList(this.createBBCode("foo", "replacement", "description", "example", true, true));
        this.cachedBBCodeService.save(bbcodes);
        this.assertNodeExists(this.bbcodesPath + "/foo=");
        BBCode actual = this.cachedBBCodeService.findById("foo=");
        TestBBcodeCacheService.assertNotNull((Object)actual);
        TestBBcodeCacheService.assertEquals((String)"foo", (String)actual.getTagName());
        TestBBcodeCacheService.assertEquals((String)"replacement", (String)actual.getReplacement());
        TestBBcodeCacheService.assertEquals((String)"description", (String)actual.getDescription());
        TestBBcodeCacheService.assertEquals((String)"example", (String)actual.getExample());
        TestBBcodeCacheService.assertEquals((boolean)true, (boolean)actual.isOption());
        TestBBcodeCacheService.assertEquals((boolean)true, (boolean)actual.isActive());
    }

    @Test
    public void testDelete() throws Exception {
        List<BBCode> bbcodes = Arrays.asList(this.createBBCode("foo", "replacement", "description", "example", false, false));
        this.cachedBBCodeService.save(bbcodes);
        String targetPath = this.bbcodesPath + "/foo";
        this.assertNodeExists(targetPath);
        this.cachedBBCodeService.delete("foo");
        this.assertNodeNotExists(targetPath);
    }
}

