/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.bbcode.core;

import java.util.Collection;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.bbcode.api.BBCode;
import org.exoplatform.forum.bbcode.api.BBCodeService;
import org.exoplatform.forum.bbcode.spi.BBCodeProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExtendedBBCodeProvider
implements BBCodeProvider {
    private static final Log log = ExoLogger.getLogger(ExtendedBBCodeProvider.class);
    protected BBCodeService bbCodeService;

    protected BBCodeService getBBCodeService() {
        if (this.bbCodeService == null) {
            this.bbCodeService = (BBCodeService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(BBCodeService.class);
        }
        return this.bbCodeService;
    }

    public void setBBCodeService(BBCodeService bbCodeService) {
        this.bbCodeService = bbCodeService;
    }

    @Override
    public BBCode getBBCode(String tagName) {
        try {
            return this.bbCodeService.findById(tagName);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    @Override
    public Collection<String> getSupportedBBCodes() {
        try {
            return this.getBBCodeService().getActive();
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }
}

