/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.cache.model;

import java.io.Serializable;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;

public class ScopeCacheKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ScopeCacheKey NULL = new ScopeCacheKey();
    private final String scope = ScopeCacheKey.getCurrentRepositoryName();

    public String getScope() {
        return this.scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScopeCacheKey)) {
            return false;
        }
        ScopeCacheKey that = (ScopeCacheKey)o;
        return !(this.scope != null ? !this.scope.equals(that.scope) : that.scope != null);
    }

    public int hashCode() {
        return this.scope != null ? this.scope.hashCode() : 0;
    }

    public static String getCurrentRepositoryName() {
        PortalContainer container = PortalContainer.getInstance();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        if (repositoryService == null) {
            container = RootContainer.getInstance().getPortalContainer(PortalContainer.getCurrentPortalContainerName());
            repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        }
        try {
            ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
            return manageableRepository == null ? null : manageableRepository.getConfiguration().getName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

