/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.persister;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.exoplatform.forum.common.persister.PersistAlgorithm;
import org.exoplatform.forum.common.persister.Persister;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PersisterTask
implements PersistAlgorithm {
    protected static final Log LOG = ExoLogger.getLogger(PersisterTask.class);
    final Persister persister;
    final long wakeupInterval;
    final Task task;
    final TimeUnit timeUnit;
    final long maxFixedSize;
    ScheduledExecutorService scheduledExecutor;

    public static Builder init() {
        return new Builder();
    }

    public PersisterTask(Builder builder) {
        this.wakeupInterval = builder.wakeupInterval;
        this.maxFixedSize = builder.maxFixedSize;
        this.persister = builder.persister;
        this.timeUnit = builder.timeUnit == null ? TimeUnit.MILLISECONDS : builder.timeUnit;
        this.task = new Task();
    }

    public void start() {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runable) {
                Thread t = new Thread(runable, "Forum-task-thread");
                t.setPriority(1);
                return t;
            }
        };
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.scheduledExecutor.scheduleWithFixedDelay(this.task, this.wakeupInterval / 2L, this.wakeupInterval, this.timeUnit);
    }

    public void stop() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
        this.scheduledExecutor = null;
    }

    @Override
    public boolean shoudldPersist(int changedSize) {
        return (long)changedSize >= this.maxFixedSize;
    }

    public static class Builder {
        public Persister persister;
        public long wakeupInterval;
        public TimeUnit timeUnit;
        public long maxFixedSize;

        public Builder persister(Persister persister) {
            this.persister = persister;
            return this;
        }

        public Builder wakeup(long interval) {
            this.wakeupInterval = interval;
            return this;
        }

        public Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder maxFixedSize(long maxFixedSize) {
            this.maxFixedSize = maxFixedSize;
            return this;
        }

        public PersisterTask build() {
            return new PersisterTask(this);
        }
    }

    public class Task
    implements Runnable {
        @Override
        public void run() {
            try {
                PersisterTask.this.persister.commit(true);
            }
            catch (Exception e) {
                LOG.error((Object)"Persist task encountered an unexpected error", (Throwable)e);
            }
        }
    }
}

