/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.rendering;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.forum.rendering.api.Renderer;
import org.exoplatform.forum.rendering.api.UnsupportedSyntaxException;
import org.exoplatform.forum.rendering.spi.MarkupRenderDelegate;
import org.exoplatform.forum.rendering.spi.RendererPlugin;

public class MarkupRenderingService {
    protected Map<String, Renderer> rendererRegistry = new HashMap<String, Renderer>();

    public void registerRenderer(RendererPlugin plugin) {
        this.registerRenderer(plugin.getRenderer());
    }

    public void registerRenderer(Renderer renderer) {
        this.rendererRegistry.put(renderer.getSyntax(), renderer);
    }

    public Renderer getRenderer(String syntax) {
        Renderer r = this.rendererRegistry.get(syntax);
        if (r == null) {
            throw new UnsupportedSyntaxException("No renderer has been registered for syntax " + syntax);
        }
        return r;
    }

    public <T> String delegateRendering(MarkupRenderDelegate<T> delegate, T target) {
        String message = delegate.getMarkup(target);
        if (message != null) {
            Renderer renderer = this.getRenderer(delegate.getSyntax(target));
            return renderer.render(message);
        }
        return null;
    }
}

