/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.extras.injection.forum;

import java.util.HashMap;
import java.util.Random;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.forum.common.jcr.PropertyReader;
import org.exoplatform.forum.extras.injection.forum.ForumInjector;
import org.exoplatform.forum.extras.injection.utils.ExoNameGenerator;
import org.exoplatform.forum.extras.injection.utils.LoremIpsum4J;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.impl.JCRDataStorage;
import org.exoplatform.services.bench.DataInjector;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;

public abstract class AbstractForumInjector
extends DataInjector {
    private static Log LOG = ExoLogger.getLogger(ForumInjector.class);
    private static final String DEFAULT_USER_BASE = "bench.user";
    private static final String DEFAULT_CATEGORY_BASE = "bench.cat";
    private static final String DEFAULT_FORUM_BASE = "bench.forum";
    private static final String DEFAULT_TOPIC_BASE = "bench.topic";
    private static final String DEFAULT_POST_BASE = "bench.post";
    private static final int DEFAULT_BYTE_SIZE_BASE = 100;
    protected static final String PASSWORD = "exo";
    protected static final String DOMAIN = "exoplatform.int";
    protected String userBase;
    protected String categoryBase;
    protected String forumBase;
    protected String topicBase;
    protected String postBase;
    protected int byteSizeBase;
    protected int userNumber;
    protected int categoryNumber;
    protected int forumNumber;
    protected int topicNumber;
    protected int postNumber;
    protected final OrganizationService organizationService;
    protected final ForumService forumService;
    protected final KSDataLocation locator;
    protected final UserHandler userHandler;
    protected final Random random;
    protected ExoNameGenerator exoNameGenerator;
    protected LoremIpsum4J lorem;

    public AbstractForumInjector() {
        PortalContainer c = PortalContainer.getInstance();
        this.forumService = (ForumService)c.getComponentInstanceOfType(ForumService.class);
        this.organizationService = (OrganizationService)c.getComponentInstanceOfType(OrganizationService.class);
        this.locator = (KSDataLocation)c.getComponentInstanceOfType(KSDataLocation.class);
        this.userHandler = this.organizationService.getUserHandler();
        this.exoNameGenerator = new ExoNameGenerator();
        this.random = new Random();
        this.lorem = new LoremIpsum4J();
    }

    public void init(String userPrefix, String categoryPrefix, String forumPrefix, String topicPrefix, String postPrefix, int byteSize) {
        this.userBase = userPrefix == null ? DEFAULT_USER_BASE : userPrefix;
        this.categoryBase = categoryPrefix == null ? DEFAULT_CATEGORY_BASE : categoryPrefix;
        this.forumBase = forumPrefix == null ? DEFAULT_FORUM_BASE : forumPrefix;
        this.topicBase = topicPrefix == null ? DEFAULT_TOPIC_BASE : topicPrefix;
        this.postBase = postPrefix == null ? DEFAULT_POST_BASE : postPrefix;
        this.byteSizeBase = byteSize == 0 ? 100 : byteSize;
        this.categoryNumber = 0;
        this.forumNumber = 0;
        this.topicNumber = 0;
        this.postNumber = 0;
        try {
            this.userNumber = this.userNumber(this.userBase);
            this.categoryNumber = this.categoryNumber(this.categoryBase);
            this.forumNumber = this.forumNumber(this.forumBase);
            this.topicNumber = this.topicNumber(this.topicBase);
            this.postNumber = this.postNumber(this.postBase);
        }
        catch (Exception e) {
            // empty catch block
        }
        LOG.info((Object)("Initial user number : " + this.userNumber));
        LOG.info((Object)("Initial category number : " + this.categoryNumber));
        LOG.info((Object)("Initial forum number : " + this.forumNumber));
        LOG.info((Object)("Initial topic number : " + this.topicNumber));
        LOG.info((Object)("Initial post number : " + this.postNumber));
    }

    public Log getLog() {
        return ExoLogger.getExoLogger(((Object)((Object)this)).getClass());
    }

    public Object execute(HashMap<String, String> stringStringHashMap) throws Exception {
        return null;
    }

    public void reject(HashMap<String, String> stringStringHashMap) throws Exception {
    }

    public int userNumber(String base) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getUserProfilesLocation()).append("/element(*,");
        sb.append(Utils.USER_PROFILES_TYPE).append(")[jcr:like(exo:userId, '%").append(base).append("%')]");
        return (int)this.forumService.search(sb.toString()).getSize();
    }

    public int categoryNumber(String base) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getForumCategoriesLocation()).append("/element(*,");
        sb.append("exo:forumCategory").append(")[jcr:like(exo:name, '%").append(base).append("%')]");
        return (int)this.forumService.search(sb.toString()).getSize();
    }

    public int forumNumber(String base) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getForumCategoriesLocation()).append("//element(*,");
        sb.append("exo:forum").append(")[jcr:like(exo:name, '%").append(base).append("%')]");
        return (int)this.forumService.search(sb.toString()).getSize();
    }

    public int topicNumber(String base) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getForumCategoriesLocation()).append("//element(*,");
        sb.append("exo:topic").append(")[jcr:like(exo:name, '%").append(base).append("%')]");
        return (int)this.forumService.search(sb.toString()).getSize();
    }

    public int postNumber(String base) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getForumCategoriesLocation()).append("//element(*,");
        sb.append("exo:post").append(")[jcr:like(exo:name, '%").append(base).append("%')]");
        return (int)this.forumService.search(sb.toString()).getSize();
    }

    public Category getCategoryByName(String catName) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getForumCategoriesLocation()).append("/element(*,");
        sb.append("exo:forumCategory").append(")[jcr:like(exo:name, '%").append(catName).append("%')]");
        NodeIterator iter = this.forumService.search(sb.toString());
        if (iter.hasNext()) {
            Node cateNode = (Node)iter.next();
            Category cat = new Category(cateNode.getName());
            cat.setPath(cateNode.getPath());
            PropertyReader reader = new PropertyReader(cateNode);
            cat.setOwner(reader.string("exo:owner"));
            cat.setCategoryName(reader.string("exo:name"));
            cat.setViewer(reader.strings("exo:viewer"));
            cat.setCreateTopicRole(reader.strings("exo:createTopicRole"));
            cat.setPoster(reader.strings("exo:poster"));
            return cat;
        }
        return null;
    }

    public Forum getForumByName(String forumName) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getForumCategoriesLocation()).append("//element(*,");
        sb.append("exo:forum").append(")[jcr:like(exo:name, '%").append(forumName).append("%')]");
        NodeIterator iter = this.forumService.search(sb.toString());
        if (iter.hasNext()) {
            Node forumNode = (Node)iter.next();
            Forum forum = new Forum();
            PropertyReader reader = new PropertyReader(forumNode);
            forum.setId(forumNode.getName());
            forum.setPath(forumNode.getPath());
            forum.setOwner(reader.string("exo:owner"));
            forum.setForumName(reader.string("exo:name"));
            forum.setViewer(reader.strings("exo:viewer"));
            return forum;
        }
        return null;
    }

    public Category getCategoryByForumName(String forumName) throws Exception {
        Node forumNode;
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getForumCategoriesLocation()).append("//element(*,");
        sb.append("exo:forum").append(")[jcr:like(exo:name, '%").append(forumName).append("%')]");
        NodeIterator iter = this.forumService.search(sb.toString());
        if (iter.hasNext() && (forumNode = (Node)iter.next()).getParent() != null) {
            Node cateNode = forumNode.getParent();
            Category cat = new Category(cateNode.getName());
            cat.setPath(cateNode.getPath());
            PropertyReader reader = new PropertyReader(cateNode);
            cat.setOwner(reader.string("exo:owner"));
            cat.setCategoryName(reader.string("exo:name"));
            return cat;
        }
        return null;
    }

    public Topic getTopicByName(String topicName) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getForumCategoriesLocation()).append("//element(*,");
        sb.append("exo:topic").append(")[jcr:like(exo:name, '%").append(topicName).append("%')]");
        NodeIterator iter = this.forumService.search(sb.toString());
        if (iter.hasNext()) {
            Node topicNode = (Node)iter.next();
            Topic topicNew = new Topic();
            PropertyReader reader = new PropertyReader(topicNode);
            topicNew.setId(topicNode.getName());
            topicNew.setPath(topicNode.getPath());
            topicNew.setTopicName(reader.string("exo:name"));
            topicNew.setCanView(reader.strings("exo:canView", new String[0]));
            return topicNew;
        }
        return null;
    }

    public Post getPostByName(String postName) throws Exception {
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getForumCategoriesLocation()).append("//element(*,");
        sb.append("exo:post").append(")[jcr:like(exo:name, '%").append(postName).append("%')]");
        NodeIterator iter = this.forumService.search(sb.toString());
        if (iter.hasNext()) {
            Node postNode = (Node)iter.next();
            Post post = new Post();
            PropertyReader reader = new PropertyReader(postNode);
            post.setId(postNode.getName());
            post.setPath(postNode.getPath());
            post.setMessage(reader.string("exo:message"));
            post.setName(reader.string("exo:name"));
            post.setNumberAttach(reader.l("exo:numberAttach"));
            if (post.getNumberAttach() > 0L) {
                post.setAttachments(JCRDataStorage.getAttachmentsByNode((Node)postNode));
            }
            post.setUserPrivate(reader.strings("exo:userPrivate"));
            return post;
        }
        return null;
    }

    public Topic getTopicByPostName(String postName) throws Exception {
        Node postNode;
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getForumCategoriesLocation()).append("//element(*,");
        sb.append("exo:post").append(")[jcr:like(exo:name, '%").append(postName).append("%')]");
        NodeIterator iter = this.forumService.search(sb.toString());
        if (iter.hasNext() && (postNode = (Node)iter.next()).getParent() != null) {
            Node topicNode = postNode.getParent();
            Topic topicNew = new Topic();
            PropertyReader reader = new PropertyReader(topicNode);
            topicNew.setId(topicNode.getName());
            topicNew.setPath(topicNode.getPath());
            topicNew.setTopicName(reader.string("exo:name"));
            return topicNew;
        }
        return null;
    }

    public Forum getForumByTopicName(String topicName) throws Exception {
        Node topicNode;
        StringBuffer sb = new StringBuffer("/jcr:root");
        sb.append("/").append(this.locator.getForumCategoriesLocation()).append("//element(*,");
        sb.append("exo:topic").append(")[jcr:like(exo:name, '%").append(topicName).append("%')]");
        NodeIterator iter = this.forumService.search(sb.toString());
        if (iter.hasNext() && (topicNode = (Node)iter.next()).getParent() != null) {
            Node forumNode = topicNode.getParent();
            Forum forum = new Forum();
            PropertyReader reader = new PropertyReader(forumNode);
            forum.setId(forumNode.getName());
            forum.setPath(forumNode.getPath());
            forum.setOwner(reader.string("exo:owner"));
            forum.setForumName(reader.string("exo:name"));
            return forum;
        }
        return null;
    }

    protected String userName() {
        return this.userBase + this.userNumber;
    }

    protected String categoryName() {
        return this.categoryBase + this.categoryNumber;
    }

    protected String forumName() {
        return this.forumBase + this.forumNumber;
    }

    protected String topicName() {
        return this.topicBase + this.topicNumber;
    }

    protected String postName() {
        return this.postBase + this.postNumber;
    }

    protected String getId(String type) {
        return type + IdGenerator.generate();
    }

    protected int param(HashMap<String, String> params, String name) {
        if (params == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        try {
            String value = params.get(name);
            if (value != null) {
                return Integer.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Integer number expected for property " + name));
        }
        return 0;
    }
}

