/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class UpdateDataJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(UpdateDataJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        ExoContainer container = CommonUtils.getExoContainer((JobExecutionContext)context);
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
        try {
            ForumService forumService = (ForumService)container.getComponentInstanceOfType(ForumService.class);
            String name = context.getJobDetail().getKey().getName();
            JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
            String path = jdatamap.getString("path");
            forumService.updateForum(path);
            JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
            JobInfo info = new JobInfo(name, "KnowledgeSuite-forum", context.getJobDetail().getJobClass());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"\n\nForum statistic updated");
            }
            schedulerService.removeJob(info);
        }
        catch (Exception e) {
            LOG.trace((Object)("\nStatistic Forum could not updated: \n" + e.getCause()));
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
        }
    }
}

