/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.user;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class AutoPruneJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(AutoPruneJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        ExoContainer container = CommonUtils.getExoContainer((JobExecutionContext)context);
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
        try {
            String desc = context.getJobDetail().getDescription();
            ForumService forumService = (ForumService)container.getComponentInstanceOfType(ForumService.class);
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            repositoryService.setCurrentRepositoryName(context.getJobDetail().getJobDataMap().getString(Utils.CACHE_REPO_NAME));
            forumService.runPrune(desc);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("\n\nAuto prune has worked on " + desc + " forum"));
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("\n\n >>>>>> AutoPrune Job error" + e.getMessage()));
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
        }
    }
}

