/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.rss;

import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.SyndFeedOutput;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.forum.common.jcr.JCRTask;
import org.exoplatform.forum.common.jcr.PropertyReader;
import org.exoplatform.forum.rss.FeedContentProvider;
import org.exoplatform.forum.rss.RSS;
import org.exoplatform.forum.rss.RSSProcess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ForumUserFeedProvider
extends RSSProcess
implements FeedContentProvider {
    private static final Log LOG = ExoLogger.getLogger(ForumUserFeedProvider.class);

    @Override
    public InputStream getFeedContent(String userId) {
        return (InputStream)this.dataLocator.getSessionManager().executeAndSave((JCRTask)new GetUserFeedStreamTask(userId));
    }

    List<String> getForumSubscription(String userId) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        String subscriptionsPath = this.dataLocator.getUserSubscriptionLocation(userId);
        Node subscriptionNode = this.getForumServiceHome().getNode(subscriptionsPath);
        PropertyReader reader = new PropertyReader(subscriptionNode);
        list.addAll(reader.list("exo:categoryIds"));
        list.addAll(reader.list("exo:forumIds"));
        list.addAll(reader.list("exo:topicIds"));
        return list;
    }

    class GetUserFeedStreamTask
    implements JCRTask<InputStream> {
        private String userId;

        public GetUserFeedStreamTask(String userId) {
            this.userId = userId;
        }

        public InputStream execute(Session session) throws Exception {
            if (this.userId == null || this.userId.trim().length() == 0) {
                LOG.warn((Object)"no feed stream was generated for null user");
                return null;
            }
            ByteArrayInputStream inputStream = null;
            HashMap<String, SyndEntry> mapEntries = new HashMap<String, SyndEntry>();
            for (String objectId : ForumUserFeedProvider.this.getForumSubscription(this.userId)) {
                SyndEntry syndEntry = null;
                try {
                    Node node = ForumUserFeedProvider.this.getNodeById(objectId);
                    RSS data = new RSS(node);
                    SyndFeed feed = data.read();
                    for (Object entry : feed.getEntries()) {
                        syndEntry = (SyndEntry)entry;
                        mapEntries.put(syndEntry.getUri(), syndEntry);
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed to get user subscription " + objectId), (Throwable)e);
                }
            }
            SyndFeed feed = RSS.createNewFeed("Forum subscriptions for " + this.userId, new Date());
            feed.setDescription(" ");
            feed.setEntries(Arrays.asList(mapEntries.values().toArray(new SyndEntry[0])));
            SyndFeedOutput output = new SyndFeedOutput();
            inputStream = new ByteArrayInputStream(output.outputString(feed).getBytes());
            return inputStream;
        }
    }
}

