/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.cache.model.data;

import java.util.Objects;
import org.exoplatform.forum.common.cache.model.CachedData;
import org.exoplatform.forum.service.Watch;

public class WatchData
implements CachedData<Watch> {
    private final String id;
    private final String userId;
    private final String email;
    private final String nodePath;
    private final String path;
    private final String typeNode;
    private final boolean isRSS;
    private final boolean isEmail;

    public WatchData(Watch watch) {
        this.id = watch.getId();
        this.userId = watch.getUserId();
        this.email = watch.getEmail();
        this.nodePath = watch.getNodePath();
        this.path = watch.getPath();
        this.typeNode = watch.getTypeNode();
        this.isRSS = watch.isAddWatchByRS();
        this.isEmail = watch.isAddWatchByEmail();
    }

    public Watch build() {
        Watch watch = new Watch();
        watch.setId(this.id);
        watch.setUserId(this.userId);
        watch.setEmail(this.email);
        watch.setNodePath(this.nodePath);
        watch.setPath(this.path);
        watch.setTypeNode(this.typeNode);
        watch.setIsAddWatchByRSS(this.isRSS);
        watch.setIsAddWatchByEmail(this.isEmail);
        return watch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchData watchData = (WatchData)o;
        return this.isRSS == watchData.isRSS && this.isEmail == watchData.isEmail && Objects.equals(this.id, watchData.id) && Objects.equals(this.userId, watchData.userId) && Objects.equals(this.email, watchData.email) && Objects.equals(this.nodePath, watchData.nodePath) && Objects.equals(this.path, watchData.path) && Objects.equals(this.typeNode, watchData.typeNode);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userId, this.email, this.nodePath, this.path, this.typeNode, this.isRSS, this.isEmail);
    }
}

