/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.forum.service.conf.DeactiveJob;
import org.exoplatform.forum.service.conf.DelayWritesJob;
import org.exoplatform.forum.service.conf.LoginJob;
import org.exoplatform.forum.service.conf.RecountActiveUserJob;
import org.exoplatform.forum.service.conf.SendMailJob;
import org.exoplatform.forum.service.conf.UpdateDataJob;
import org.exoplatform.forum.service.conf.UpdateUserProfileJob;
import org.exoplatform.forum.service.user.AutoPruneJob;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;

@Managed
@NameTemplate(value={@Property(key="service", value="forum"), @Property(key="view", value="jobs"), @Property(key="name", value="{Name}")})
@ManagedDescription(value="Forum management jobs")
public class JobManager {
    JobDetail jobDetail;
    public static final List<String> forumJobs = Arrays.asList(DeactiveJob.class.getName(), DelayWritesJob.class.getName(), LoginJob.class.getName(), RecountActiveUserJob.class.getName(), SendMailJob.class.getName(), UpdateDataJob.class.getName(), UpdateUserProfileJob.class.getName(), AutoPruneJob.class.getName());

    public JobManager(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    @Managed
    @ManagedName(value="Name")
    public String getName() {
        return this.jobDetail.getKey().getName();
    }

    @Managed
    @ManagedName(value="DataMap")
    public JobDataMap getDataMap() {
        return this.jobDetail.getJobDataMap();
    }

    @Managed
    @ManagedName(value="JobClassName")
    public String getJobClassName() {
        return this.jobDetail.getJobClass().getName();
    }
}

