/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class LoginJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(LoginJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        ExoContainer container = CommonUtils.getExoContainer((JobExecutionContext)context);
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
        try {
            ForumService forumService = (ForumService)container.getComponentInstanceOfType(ForumService.class);
            String masterHost = System.getProperty("tenant.masterhost");
            if (masterHost == null) {
                forumService.updateLoggedinUsers();
            } else {
                ManageableRepository repository = SessionProviderService.getRepository();
                String currentLoginRepo = repository.getConfiguration().getName();
                forumService.updateLoggedinUsers(currentLoginRepo);
            }
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)"\n\nForum Statistic has been updated for logged in user by a period login job");
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Period login job can not execute ...", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
        }
    }
}

