/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.cache.model.data;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.exoplatform.forum.common.cache.model.CachedData;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Utils;

public class CategoryData
implements CachedData<Category> {
    private static final long serialVersionUID = 1L;
    public static final CategoryData NULL = new CategoryData(new Category());
    private final String id;
    private final String owner;
    private final String path;
    private final long categoryOrder;
    private final Date createdDate;
    private final String modifiedBy;
    private final Date modifiedDate;
    private final String name;
    private final String description;
    private final String[] moderators;
    private final String[] userPrivate;
    private final String[] createTopicRole;
    private final String[] viewer;
    private final String[] poster;
    private final long forumCount;
    private final String[] emailNotification;

    public CategoryData(Category category) {
        this.id = category.getId();
        this.owner = category.getOwner();
        this.path = category.getPath();
        this.categoryOrder = category.getCategoryOrder();
        this.createdDate = category.getCreatedDate();
        this.modifiedBy = category.getModifiedBy();
        this.modifiedDate = category.getModifiedDate();
        this.name = category.getCategoryName();
        this.description = category.getDescription();
        this.moderators = category.getModerators();
        this.userPrivate = category.getUserPrivate();
        this.createTopicRole = category.getCreateTopicRole();
        this.viewer = category.getViewer();
        this.poster = category.getPoster();
        this.forumCount = category.getForumCount();
        this.emailNotification = category.getEmailNotification();
    }

    public Category build() {
        if (this == NULL) {
            return null;
        }
        Category category = new Category();
        category.setId(this.id);
        category.setOwner(this.owner);
        category.setPath(this.path);
        category.setCategoryOrder(this.categoryOrder);
        category.setCreatedDate(this.createdDate);
        category.setModifiedBy(this.modifiedBy);
        category.setModifiedDate(this.modifiedDate);
        category.setCategoryName(this.name);
        category.setDescription(this.description);
        category.setModerators(this.moderators);
        category.setCreateTopicRole(this.createTopicRole);
        category.setViewer(this.viewer);
        category.setPoster(this.poster);
        category.setForumCount(this.forumCount);
        category.setEmailNotification(this.emailNotification);
        if (Utils.isEmpty(this.userPrivate)) {
            category.setUserPrivate(new String[0]);
        } else {
            category.setUserPrivate(this.userPrivate);
        }
        return category;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryData that = (CategoryData)o;
        return this.categoryOrder == that.categoryOrder && this.forumCount == that.forumCount && Objects.equals(this.id, that.id) && Objects.equals(this.owner, that.owner) && Objects.equals(this.path, that.path) && Objects.equals(this.createdDate, that.createdDate) && Objects.equals(this.modifiedBy, that.modifiedBy) && Objects.equals(this.modifiedDate, that.modifiedDate) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Arrays.equals(this.moderators, that.moderators) && Arrays.equals(this.userPrivate, that.userPrivate) && Arrays.equals(this.createTopicRole, that.createTopicRole) && Arrays.equals(this.viewer, that.viewer) && Arrays.equals(this.poster, that.poster) && Arrays.equals(this.emailNotification, that.emailNotification);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.owner, this.path, this.categoryOrder, this.createdDate, this.modifiedBy, this.modifiedDate, this.name, this.description, this.moderators, this.userPrivate, this.createTopicRole, this.viewer, this.poster, this.forumCount, this.emailNotification);
    }
}

