/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.cache.model.data;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.exoplatform.forum.common.cache.model.CachedData;
import org.exoplatform.forum.service.UserProfile;

public class UserProfileData
implements CachedData<UserProfile> {
    private static final long serialVersionUID = 1L;
    private String userId;
    private String screenName;
    private String userTitle;
    private long userRole;
    private String signature = "";
    private Date joinedDate = null;
    private Date lastLoginDate = null;
    private Date lastPostDate = null;
    private boolean isDisplaySignature = true;
    private boolean isDisplayAvatar = true;
    private boolean isBanned = false;
    private boolean isDisabled = false;
    private long banUntil = 0L;
    private String banReason;
    private int banCounter = 0;
    private String[] banReasonSummary;
    private Date createdDateBan;
    private Double timeZone;
    private String shortDateformat;
    private String longDateformat;
    private long maxTopic = 10L;
    private long maxPost = 10L;
    private long totalPost = 0L;
    private String[] moderateForums;
    private String[] moderateCategory;

    public UserProfileData(UserProfile profile) {
        this.userId = profile.getUserId();
        this.userTitle = profile.getUserTitle();
        this.screenName = profile.getScreenName();
        this.userRole = profile.getUserRole();
        this.signature = profile.getSignature();
        this.lastLoginDate = profile.getLastLoginDate();
        this.joinedDate = profile.getJoinedDate();
        this.lastPostDate = profile.getLastPostDate();
        this.totalPost = profile.getTotalPost();
        this.isDisplaySignature = profile.getIsDisplaySignature();
        this.isDisplayAvatar = profile.getIsDisplayAvatar();
        this.timeZone = profile.getTimeZone();
        this.shortDateformat = profile.getShortDateFormat();
        this.longDateformat = profile.getLongDateFormat();
        this.moderateForums = profile.getModerateForums();
        this.moderateCategory = profile.getModerateCategory();
        this.maxTopic = profile.getMaxTopicInPage();
        this.maxPost = profile.getMaxPostInPage();
        this.isBanned = profile.getIsBanned();
        this.banUntil = profile.getBanUntil();
        this.banReason = profile.getBanReason();
        this.banCounter = profile.getBanCounter();
        this.banReasonSummary = profile.getBanReasonSummary();
        this.createdDateBan = profile.getCreatedDateBan();
        this.isDisabled = profile.isDisabled();
    }

    public UserProfile build() {
        UserProfile userProfile = new UserProfile();
        userProfile.setUserId(this.userId);
        userProfile.setUserTitle(this.userTitle);
        userProfile.setScreenName(this.screenName);
        userProfile.setUserRole(this.userRole);
        userProfile.setSignature(this.signature);
        userProfile.setLastLoginDate(this.lastLoginDate);
        userProfile.setJoinedDate(this.joinedDate);
        userProfile.setLastPostDate(this.lastPostDate);
        userProfile.setTotalPost(this.totalPost);
        userProfile.setIsDisplaySignature(this.isDisplaySignature);
        userProfile.setIsDisplayAvatar(this.isDisplayAvatar);
        userProfile.setTimeZone(this.timeZone);
        userProfile.setShortDateFormat(this.shortDateformat);
        userProfile.setLongDateFormat(this.longDateformat);
        userProfile.setModerateForums(this.moderateForums);
        userProfile.setModerateCategory(this.moderateCategory);
        userProfile.setMaxPostInPage(this.maxPost);
        userProfile.setMaxTopicInPage(this.maxTopic);
        userProfile.setIsBanned(this.isBanned);
        userProfile.setBanUntil(this.banUntil);
        userProfile.setBanReason(this.banReason);
        userProfile.setBanCounter(this.banCounter);
        userProfile.setBanReasonSummary(this.banReasonSummary);
        userProfile.setCreatedDateBan(this.createdDateBan);
        userProfile.setDisabled(this.isDisabled);
        return userProfile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserProfileData that = (UserProfileData)o;
        return this.userRole == that.userRole && this.isDisplaySignature == that.isDisplaySignature && this.isDisplayAvatar == that.isDisplayAvatar && this.isBanned == that.isBanned && this.isDisabled == that.isDisabled && this.banUntil == that.banUntil && this.banCounter == that.banCounter && this.maxTopic == that.maxTopic && this.maxPost == that.maxPost && this.totalPost == that.totalPost && Objects.equals(this.userId, that.userId) && Objects.equals(this.screenName, that.screenName) && Objects.equals(this.userTitle, that.userTitle) && Objects.equals(this.signature, that.signature) && Objects.equals(this.joinedDate, that.joinedDate) && Objects.equals(this.lastLoginDate, that.lastLoginDate) && Objects.equals(this.lastPostDate, that.lastPostDate) && Objects.equals(this.banReason, that.banReason) && Arrays.equals(this.banReasonSummary, that.banReasonSummary) && Objects.equals(this.createdDateBan, that.createdDateBan) && Objects.equals(this.timeZone, that.timeZone) && Objects.equals(this.shortDateformat, that.shortDateformat) && Objects.equals(this.longDateformat, that.longDateformat) && Arrays.equals(this.moderateForums, that.moderateForums) && Arrays.equals(this.moderateCategory, that.moderateCategory);
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.screenName, this.userTitle, this.userRole, this.signature, this.joinedDate, this.lastLoginDate, this.lastPostDate, this.isDisplaySignature, this.isDisplayAvatar, this.isBanned, this.isDisabled, this.banUntil, this.banReason, this.banCounter, this.banReasonSummary, this.createdDateBan, this.timeZone, this.shortDateformat, this.longDateformat, this.maxTopic, this.maxPost, this.totalPost, this.moderateForums, this.moderateCategory);
    }
}

