/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.bbcode.core;

import java.util.Collection;
import java.util.HashMap;
import org.exoplatform.forum.bbcode.api.BBCode;
import org.exoplatform.forum.bbcode.spi.BBCodeProvider;

public class BuiltinBBCodeProvider
extends HashMap<String, BBCode>
implements BBCodeProvider {
    private static final long serialVersionUID = -4330438782881224247L;

    public BuiltinBBCodeProvider() {
        this.addBBCode("I", "<i>{param}</i>", false);
        this.addBBCode("B", "<strong>{param}</strong>", false);
        this.addBBCode("U", "<u>{param}</u>", false);
        this.addBBCode("COLOR", "<font color='{option}'>{param}</font>", true);
        this.addBBCode("SIZE", "<font size='{option}'>{param}</font>", true);
        this.addBBCode("FONT", "<font face='{option}'>{param}</font>", true);
        this.addBBCode("HIGHLIGHT", "<span class='highlighted'>{param}</span>", false);
        this.addBBCode("LEFT", "<div align='left'>{param}</div>", false);
        this.addBBCode("RIGHT", "<div align='right'>{param}</div>", false);
        this.addBBCode("CENTER", "<div align='center'>{param}</div>", false);
        this.addBBCode("JUSTIFY", "<div align='justify'>{param}</div>", false);
        this.addBBCode("EMAIL", "<a href='mailto:{param}'>{param}</a>", false);
        this.addBBCode("EMAIL", "<a href='mailto:{option}'>{param}</a>", true);
        this.addBBCode("URL", "<a target='_blank' href='{param}'>{param}</a>", false);
        this.addBBCode("URL", "<a target='_blank' href='{option}'>{param}</a>", true);
        this.addBBCode("GOTO", "<a href='{option}'>{param}</a>", true);
        this.addBBCode("LIST", "", false);
        this.addBBCode("LIST", "", true);
        this.addBBCode("IMG", "<img border='0' alt='{param}' src='{param}' class='inlineimg'/>", false);
        this.addBBCode("QUOTE", "<blockquote>{param}</blockquote>", false);
        this.addBBCode("QUOTE", "<blockquote cite='{option}'>param</blockquote>", true);
        this.addBBCode("CSS", "<span class='{option}'>{param}</span>", true);
    }

    private void addBBCode(String tag, String replacement, boolean option) {
        replacement = replacement.replaceAll("'", "\"");
        BBCode bbCode = new BBCode();
        String id = option ? tag + "=" : tag;
        bbCode.setTagName(tag);
        bbCode.setId(id);
        bbCode.setReplacement(replacement);
        bbCode.setOption(option);
        bbCode.setActive(true);
        super.put(id, bbCode);
    }

    @Override
    public BBCode getBBCode(String tagName) {
        return (BBCode)this.get(tagName);
    }

    @Override
    public Collection<String> getSupportedBBCodes() {
        return this.keySet();
    }
}

