/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class UpdateUserProfileJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(UpdateUserProfileJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        ExoContainer container = CommonUtils.getExoContainer((JobExecutionContext)context);
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
        try {
            ExoContainer exoContainer = CommonUtils.getExoContainer((JobExecutionContext)context);
            ForumService forumService = (ForumService)exoContainer.getComponentInstanceOfType(ForumService.class);
            ExoContainerContext.setCurrentContainer((ExoContainer)exoContainer);
            String name = context.getJobDetail().getKey().getName();
            JobSchedulerService schedulerService = (JobSchedulerService)exoContainer.getComponentInstanceOfType(JobSchedulerService.class);
            JobInfo info = new JobInfo(name, "KnowledgeSuite-forum", context.getJobDetail().getJobClass());
            RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
            repositoryService.setCurrentRepositoryName(context.getJobDetail().getJobDataMap().getString(Utils.CACHE_REPO_NAME));
            forumService.updateUserProfileInfo(name);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"\n\nNumber of deleted posts, topics updated to Forum statistics and user's profile");
            }
            schedulerService.removeJob(info);
        }
        catch (Exception e) {
            LOG.trace((Object)("User profile could not updated: \n" + e.getCause()));
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
        }
    }
}

