/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.rss;

import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndContentImpl;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.forum.common.jcr.JCRTask;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.forum.common.jcr.PropertyReader;
import org.exoplatform.forum.common.jcr.VoidReturn;
import org.exoplatform.forum.rss.FeedContentProvider;
import org.exoplatform.forum.rss.FeedListener;
import org.exoplatform.forum.rss.RSS;
import org.exoplatform.forum.rss.RSSProcess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public final class ForumFeedGenerator
extends RSSProcess
implements FeedContentProvider,
FeedListener {
    private static final Log LOG = ExoLogger.getLogger(ForumFeedGenerator.class);
    public static final String FORUM_RSS_TYPE = "exo:forumRSS".intern();
    public static final String KS_FORUM = "forum".intern();
    public static final String FORUM_APP = "ForumService".intern();

    public ForumFeedGenerator(KSDataLocation locator) {
        super(locator);
    }

    public ForumFeedGenerator() {
    }

    @Override
    public void itemAdded(String path) {
        try {
            ItemSavedTask task = new ItemSavedTask(path, false);
            this.dataLocator.getSessionManager().executeAndSave((JCRTask)task);
        }
        catch (Exception e) {
            LOG.error((Object)("itemAdded failed for " + path), (Throwable)e);
        }
    }

    @Override
    public void itemUpdated(String path) {
        try {
            ItemSavedTask task = new ItemSavedTask(path, true);
            this.dataLocator.getSessionManager().executeAndSave((JCRTask)task);
        }
        catch (Exception e) {
            LOG.error((Object)("itemUpdated failed for" + path), (Throwable)e);
        }
    }

    @Override
    public void itemRemoved(String path) {
        try {
            ItemRemovedTask task = new ItemRemovedTask(path);
            this.dataLocator.getSessionManager().executeAndSave((JCRTask)task);
        }
        catch (Exception e) {
            LOG.error((Object)("itemRemoved failed for " + path), (Throwable)e);
        }
    }

    protected void removeItemInFeed(String itemId, Node node, String feedDescription) throws Exception {
        RSS data = new RSS(node);
        SyndFeed feed = data.removeEntry(itemId);
        String title = new PropertyReader(node).string("exo:name", "Root");
        feed.setTitle(title);
        feed.setDescription(feedDescription);
        data.saveFeed(feed, FORUM_RSS_TYPE);
    }

    protected void removeRSSItem(String itemId, Node node, String description) throws Exception {
        RSS data = new RSS(node);
        SyndFeed feed = data.read();
        List entries = feed.getEntries();
        Node removeNode = this.getNodeById(itemId);
        if (removeNode.isNodeType("exo:topic")) {
            List<Node> listRemovePosts = this.getListRemove(removeNode, "exo:post");
            this.removeItem(entries, listRemovePosts);
        } else if (removeNode.isNodeType("exo:forum")) {
            List<Node> listRemoveForum = this.getListRemove(removeNode, "exo:topic");
            for (Node n : listRemoveForum) {
                List<Node> listRemovePosts = this.getListRemove(n, "exo:post");
                this.removeItem(entries, listRemovePosts);
            }
            this.removeItem(entries, listRemoveForum);
        }
        feed.setEntries(entries);
        String title = new PropertyReader(node).string("exo:name", "Root");
        feed.setTitle(title);
        feed.setDescription(description);
        data.saveFeed(feed, FORUM_RSS_TYPE);
    }

    protected void removeItem(List<SyndEntry> entries, List<Node> listRemove) throws RepositoryException {
        ArrayList<SyndEntry> entries1 = new ArrayList<SyndEntry>();
        boolean flag = true;
        for (SyndEntry syndEntry : entries) {
            flag = true;
            for (Node post : listRemove) {
                if (!syndEntry.getUri().equals(post.getName())) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            entries1.add(syndEntry);
        }
        entries.clear();
        entries.addAll(entries1);
    }

    protected List<Node> getListRemove(Node removeNode, String childNodeType) throws RepositoryException {
        ArrayList<Node> listRemove = new ArrayList<Node>();
        NodeIterator nodeIterator = removeNode.getNodes();
        Node nodePost = null;
        while (nodeIterator.hasNext()) {
            nodePost = nodeIterator.nextNode();
            if (!nodePost.isNodeType(childNodeType)) continue;
            listRemove.add(nodePost);
        }
        return listRemove;
    }

    protected void topicUpdated(String path, String linkItem, boolean updated) {
        try {
            Node topicNode = (Node)this.getCurrentSession().getItem(path);
            Node forumNode = topicNode.getParent();
            Node categoryNode = forumNode.getParent();
            boolean categoryHasRestrictedAudience = this.hasProperty(categoryNode, "exo:viewer");
            boolean forumHasRestrictedAudience = this.hasProperty(forumNode, "exo:viewer");
            boolean debug = LOG.isDebugEnabled();
            String topicName = topicNode.getName();
            if (categoryHasRestrictedAudience || forumHasRestrictedAudience) {
                if (debug) {
                    LOG.debug((Object)("Post" + topicName + " was not added to feed because category or forum has restricted audience"));
                }
                return;
            }
            PropertyReader topic = new PropertyReader(topicNode);
            ArrayList<String> listContent = new ArrayList<String>();
            String message = topic.string("exo:description");
            listContent.add(message);
            SyndContentImpl description = new SyndContentImpl();
            description.setType(RSS.PLAIN_TEXT);
            description.setValue(message);
            String title = topic.string("exo:name");
            Date created = topic.date("exo:createdDate");
            String owner = topic.string("exo:owner");
            SyndEntry entry = RSS.createNewEntry(topicName, title, linkItem, listContent, (SyndContent)description, created, owner);
            entry.setLink(linkItem + topicNode.getName());
            for (Node node : new Node[]{forumNode, categoryNode}) {
                SyndFeed feed;
                PropertyReader reader = new PropertyReader(node);
                String desc = reader.string("exo:description", " ");
                RSS data = new RSS(node);
                if (data.feedExists()) {
                    feed = null;
                    if (updated) {
                        feed = data.removeEntry(topicName);
                    }
                    feed = data.addEntry(entry);
                    feed.setDescription(reader.string("exo:description", " "));
                    data.saveFeed(feed, FORUM_RSS_TYPE);
                    continue;
                }
                feed = RSS.createNewFeed(node.getProperty("exo:name").getString(), node.getProperty("exo:createdDate").getDate().getTime());
                feed.setLink(linkItem + node.getName());
                feed.setEntries(Arrays.asList(entry));
                feed.setDescription(desc);
                data.saveFeed(feed, FORUM_RSS_TYPE);
            }
            NodeIterator nodeIterator = topicNode.getNodes();
            Node postNode = null;
            while (nodeIterator.hasNext()) {
                postNode = nodeIterator.nextNode();
                if (!postNode.isNodeType("exo:post")) continue;
                try {
                    this.postUpdated(postNode, linkItem, updated);
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Failed to generate feed for post " + postNode.getPath()), (Throwable)e);
                }
            }
        }
        catch (PathNotFoundException e) {
            LOG.warn((Object)"Failed to get properties", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to update topics", (Throwable)e);
        }
    }

    protected void forumUpdated(String path, String linkItem, boolean updated) {
        try {
            Node forumNode = (Node)this.getCurrentSession().getItem(path);
            NodeIterator nodeIterator = forumNode.getNodes();
            Node topicNode = null;
            while (nodeIterator.hasNext()) {
                topicNode = nodeIterator.nextNode();
                if (!topicNode.isNodeType("exo:topic")) continue;
                this.topicUpdated(topicNode.getPath(), linkItem, updated);
            }
        }
        catch (PathNotFoundException e) {
            LOG.warn((Object)("Failed to get item with path " + path), (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.warn((Object)("Failed to get item with path " + path), (Throwable)e);
        }
    }

    private void postUpdated(Node postNode, String linkItem, boolean updated) throws Exception {
        boolean debug = LOG.isDebugEnabled();
        Node topicNode = postNode.getParent();
        String postName = postNode.getName();
        PropertyReader post = new PropertyReader(postNode);
        PropertyReader topic = new PropertyReader(topicNode);
        boolean isFirstPost = post.bool("exo:isFirstPost");
        boolean notApproved = post.bool("exo:isApproved") == false;
        boolean isPrivatePost = this.hasProperty(topicNode, "exo:userPrivate") && !"exoUserPri".equals(topic.strings("exo:userPrivate")[0]);
        boolean topicHasLimitedViewers = this.hasProperty(topicNode, "exo:canView");
        if (isFirstPost && notApproved || isPrivatePost || topicHasLimitedViewers) {
            if (debug) {
                LOG.debug((Object)("Post" + postName + " was not added to feed because it is private or topic has restricted audience or it is approval pending"));
            }
            return;
        }
        Node forumNode = topicNode.getParent();
        Node categoryNode = forumNode.getParent();
        boolean categoryHasRestrictedAudience = this.hasProperty(categoryNode, "exo:viewer");
        boolean forumHasRestrictedAudience = this.hasProperty(forumNode, "exo:viewer");
        if (categoryHasRestrictedAudience || forumHasRestrictedAudience) {
            if (debug) {
                LOG.debug((Object)("Post" + postName + " was not added to feed because category or forum has restricted audience"));
            }
            return;
        }
        boolean inactive = post.bool("exo:isActiveByTopic") == false;
        boolean hidden = post.bool("exo:isHidden");
        if (notApproved || inactive || hidden) {
            if (updated) {
                this.removePostFromParentFeeds(postNode, topicNode, forumNode, categoryNode);
            }
            if (debug) {
                LOG.debug((Object)("Post" + postName + " was not added to feed because because it is hidden, inactive or not approved"));
            }
            return;
        }
        ArrayList<String> listContent = new ArrayList<String>();
        String message = post.string("exo:message");
        listContent.add(message);
        SyndContentImpl description = new SyndContentImpl();
        description.setType(RSS.PLAIN_TEXT);
        description.setValue(message);
        String title = post.string("exo:name");
        Date created = post.date("exo:createdDate");
        String owner = post.string("exo:owner");
        SyndEntry entry = RSS.createNewEntry(postName, title, linkItem, listContent, (SyndContent)description, created, owner);
        entry.setLink(linkItem + topicNode.getName());
        for (Node node : new Node[]{topicNode, forumNode, categoryNode}) {
            SyndFeed feed;
            PropertyReader reader = new PropertyReader(node);
            String desc = reader.string("exo:description", " ");
            RSS data = new RSS(node);
            if (data.feedExists()) {
                feed = null;
                if (updated) {
                    feed = data.removeEntry(postName);
                }
                feed = data.addEntry(entry);
                feed.setDescription(reader.string("exo:description", " "));
                data.saveFeed(feed, FORUM_RSS_TYPE);
                continue;
            }
            feed = RSS.createNewFeed(title, created);
            feed.setLink(linkItem + node.getName());
            feed.setEntries(Arrays.asList(entry));
            feed.setDescription(desc);
            data.saveFeed(feed, FORUM_RSS_TYPE);
        }
    }

    protected void postUpdated(String path, String linkItem, boolean updated) {
        try {
            Node postNode = (Node)this.getCurrentSession().getItem(path);
            this.postUpdated(postNode, linkItem, updated);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to generate feed for post" + path), (Throwable)e);
        }
    }

    private void removePostFromParentFeeds(Node postNode, Node topicNode, Node forumNode, Node categoryNode) throws Exception {
        for (Node node : new Node[]{topicNode, forumNode, categoryNode}) {
            String description = new PropertyReader(node).string("exo:description", " ");
            RSS data = new RSS(node);
            SyndFeed feed = data.removeEntry(postNode.getName());
            String title = new PropertyReader(node).string("exo:name", "Root");
            feed.setTitle(title);
            feed.setDescription(description);
            data.saveFeed(feed, FORUM_RSS_TYPE);
        }
    }

    private boolean hasProperty(Node node, String property) throws Exception {
        return node.hasProperty(property) && node.getProperty(property).getValues().length > 0 && node.getProperty(property).getValues()[0].getString().trim().length() > 0;
    }

    @Override
    public InputStream getFeedContent(String targetId) {
        return (InputStream)this.dataLocator.getSessionManager().executeAndSave((JCRTask)new GetFeedStreamTask(targetId));
    }

    class ItemSavedTask
    implements JCRTask<VoidReturn> {
        private String path;
        private boolean updated;

        public ItemSavedTask(String path, boolean updated) {
            this.path = path;
            this.updated = updated;
        }

        public VoidReturn execute(Session session) throws Exception {
            Node node = (Node)ForumFeedGenerator.this.getCurrentSession().getItem(this.path);
            Object linkItem = ForumFeedGenerator.this.getPageLink() + "?portal:componentId=forum&portal:type=action&portal:isSecure=false&uicomponent=UIBreadcumbs&op=ChangePath&objectId=";
            if (node.isNodeType("exo:post")) {
                linkItem = node.getProperty("exo:link").getString();
                linkItem = ((String)linkItem).substring(0, ((String)linkItem).indexOf("objectId=") + 9);
                ForumFeedGenerator.this.postUpdated(this.path, (String)linkItem, this.updated);
            } else if (node.isNodeType("exo:topic")) {
                ForumFeedGenerator.this.topicUpdated(this.path, (String)linkItem, this.updated);
            } else if (node.isNodeType("exo:forum")) {
                ForumFeedGenerator.this.forumUpdated(this.path, (String)linkItem, this.updated);
            }
            return VoidReturn.VALUE;
        }
    }

    class ItemRemovedTask
    implements JCRTask<VoidReturn> {
        private String path;

        public ItemRemovedTask(String path) {
            this.path = path;
        }

        public VoidReturn execute(Session session) throws Exception {
            String objectId = null;
            String description = null;
            objectId = this.path.substring(this.path.lastIndexOf("/") + 1);
            Node node = null;
            if (objectId.contains("post")) {
                while (node == null) {
                    try {
                        node = (Node)ForumFeedGenerator.this.getCurrentSession().getItem(this.path);
                    }
                    catch (PathNotFoundException pn) {
                        this.path = this.path.substring(0, this.path.lastIndexOf("/"));
                        node = null;
                    }
                }
                while (node.isNodeType("exo:forumCategory") || node.isNodeType("exo:forum") || node.isNodeType("exo:topic")) {
                    description = new PropertyReader(node).string("exo:description", " ");
                    ForumFeedGenerator.this.removeItemInFeed(objectId, node, description);
                    node = node.getParent();
                }
            } else {
                this.path = this.path.substring(0, this.path.lastIndexOf("/"));
                while (node == null) {
                    try {
                        node = (Node)ForumFeedGenerator.this.getCurrentSession().getItem(this.path);
                    }
                    catch (PathNotFoundException pn) {
                        objectId = this.path.substring(this.path.lastIndexOf("/") + 1);
                        this.path = this.path.substring(0, this.path.lastIndexOf("/"));
                        node = null;
                    }
                }
                while (node.isNodeType("exo:forumCategory") || node.isNodeType("exo:forum") || node.isNodeType("exo:topic")) {
                    description = new PropertyReader(node).string("exo:description", " ");
                    if (node.isNodeType("exo:forum") || node.isNodeType("exo:forumCategory")) {
                        ForumFeedGenerator.this.removeRSSItem(objectId, node, description);
                    } else {
                        ForumFeedGenerator.this.removeItemInFeed(objectId, node, description);
                    }
                    node = node.getParent();
                }
            }
            return VoidReturn.VALUE;
        }
    }

    class GetFeedStreamTask
    implements JCRTask<InputStream> {
        private String targetId;

        public GetFeedStreamTask(String targetId) {
            this.targetId = targetId;
        }

        public InputStream execute(Session session) throws Exception {
            Node parentNode = ForumFeedGenerator.this.getNodeById(this.targetId);
            return ForumFeedGenerator.this.getFeedStream(parentNode, FORUM_RSS_TYPE, "FORUM RSS FEED");
        }
    }
}

