/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.integration.gamification;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.forum.integration.gamification.ForumUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumEventListener;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class GamificationForumListener
extends ForumEventListener {
    private static final Log LOG = ExoLogger.getLogger(GamificationForumListener.class);
    private static final String GAMIFICATION_FORUM_ADD_POST = "addForumPost";
    private static final String GAMIFICATION_FORUM_ADD_TOPIC = "addForumTopic";
    private static final String GAMIFICATION_FORUM_VOTE_TOPIC = "voteForumTopic";
    protected IdentityManager identityManager;
    protected SpaceService spaceService;
    protected ListenerService listenerService;
    protected ActivityManager activityManager;
    protected ForumService forumService;

    public GamificationForumListener(IdentityManager identityManager, SpaceService spaceService, ListenerService listenerService, ActivityManager activityManager, ForumService forumService) {
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.listenerService = listenerService;
        this.activityManager = activityManager;
        this.forumService = forumService;
    }

    public void saveCategory(Category category) {
    }

    public void saveForum(Forum forum) {
    }

    public void addPost(Post post) {
        String actorId = this.identityManager.getOrCreateIdentity("organization", post.getOwner(), false).getId();
        try {
            HashMap<String, String> gamificationRule = new HashMap<String, String>();
            gamificationRule.put("ruleTitle", GAMIFICATION_FORUM_ADD_POST);
            gamificationRule.put("senderId", actorId);
            gamificationRule.put("receiverId", actorId);
            gamificationRule.put("object", ForumUtils.createdSubForumLink(post.toString(), post.getTopicId(), true));
            this.listenerService.broadcast("exo.gamification.generic.action", gamificationRule, (Object)"");
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot broadcast add forum post Gamification event" + e.getMessage()), (Throwable)e);
        }
    }

    public void updatePost(Post post) {
    }

    public void updatePost(Post post, int type) {
    }

    public void addTopic(Topic topic) {
        String actorId = this.identityManager.getOrCreateIdentity("organization", topic.getOwner(), false).getId();
        try {
            HashMap<String, String> gamificationRule = new HashMap<String, String>();
            gamificationRule.put("ruleTitle", GAMIFICATION_FORUM_ADD_TOPIC);
            gamificationRule.put("senderId", actorId);
            gamificationRule.put("receiverId", actorId);
            gamificationRule.put("object", ForumUtils.createdSubForumLink(topic.toString(), topic.getId(), true));
            this.listenerService.broadcast("exo.gamification.generic.action", gamificationRule, (Object)"");
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot broadcast add forum topic Gamification event" + e.getMessage()), (Throwable)e);
        }
    }

    public void updateTopic(Topic topic) {
        PropertyChangeEvent[] events = topic.getChangeEvent();
        for (int i = 0; i < events.length; ++i) {
            this.processUpdateTopicType(events[i], topic);
        }
    }

    public void updateTopics(List<Topic> topics, boolean isLock) {
    }

    public void moveTopic(Topic topic, String toCategoryName, String toForumName) {
    }

    public void mergeTopic(Topic newTopic, String removeActivityId1, String removeActivityId2) {
    }

    public void splitTopic(Topic newTopic, Topic splitedTopic, String removeActivityId) {
    }

    public void removeActivity(String activityId) {
    }

    public void removeComment(String activityId, String commentId) {
    }

    public void movePost(List<Post> list, List<String> list1, String s) {
    }

    public void openTopic(String userId, String topicId) {
    }

    private void processUpdateTopicType(PropertyChangeEvent event, Topic topic) {
        if (Topic.TOPIC_RATING.equals(event.getPropertyName())) {
            String actorId = this.identityManager.getOrCreateIdentity("organization", topic.getOwner(), false).getId();
            try {
                HashMap<String, String> gamificationRule = new HashMap<String, String>();
                gamificationRule.put("ruleTitle", GAMIFICATION_FORUM_VOTE_TOPIC);
                gamificationRule.put("senderId", actorId);
                gamificationRule.put("receiverId", actorId);
                gamificationRule.put("object", ForumUtils.createdSubForumLink(topic.toString(), topic.getId(), true));
                this.listenerService.broadcast("exo.gamification.generic.action", gamificationRule, (Object)"");
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot broadcast add forum topic vote Gamification event" + e.getMessage()), (Throwable)e);
            }
        }
    }
}

