/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.poll.webui;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.common.webui.UIForumCheckBoxInput;
import org.exoplatform.forum.common.webui.UIPollRadioBoxInput;
import org.exoplatform.poll.Utils;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollNodeTypes;
import org.exoplatform.poll.webui.BasePollForm;
import org.exoplatform.poll.webui.UIPoll;
import org.exoplatform.poll.webui.UIPollPortlet;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/poll/webui/UIPoll.gtmpl", events={@EventConfig(listeners={VoteActionListener.class}), @EventConfig(listeners={EditPollActionListener.class}), @EventConfig(listeners={RemovePollActionListener.class}, confirm="UIPoll.msg.confirm-RemovePoll"), @EventConfig(listeners={ClosedPollActionListener.class}), @EventConfig(listeners={VoteAgainPollActionListener.class})})
public class UIPoll
extends BasePollForm {
    private final String POLL_OPTION_ID = "option";
    private static final String POLL_OPTION_VALUE = "pollOption";
    private Poll poll_;
    private String pollId;
    private String userId;
    private boolean isAgainVote = false;
    private boolean isEditPoll = false;
    private boolean hasPermission = true;
    private boolean isAdmin = false;
    private String[] dateUnit = new String[]{this.getLabel("Never"), this.getLabel("Closed"), this.getLabel("day"), this.getLabel("hour"), this.getLabel("minutes")};

    public void setPollId() throws Exception {
        List list;
        UIPollPortlet pollPortlet = (UIPollPortlet)this.getAncestorOfType(UIPollPortlet.class);
        this.isAdmin = pollPortlet.isAdmin();
        this.userId = pollPortlet.getUserId();
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        this.pollId = portletPref.getValue(Utils.POLL_ID_SHOW, "");
        if (Utils.isEmpty((String)this.pollId) && !(list = this.getPollService().getPollSummary(null).getPollId()).isEmpty()) {
            this.pollId = (String)list.iterator().next();
        }
        this.isEditPoll = true;
    }

    public boolean hasUserInGroup(String groupId, String userId) throws Exception {
        try {
            OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
            for (Object object : organizationService.getGroupHandler().findGroupsOfUser(userId)) {
                if (!((Group)object).getId().equals(groupId)) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.log.debug((Object)"Failed to check user permission by OrganizationService !", (Throwable)e);
        }
        return false;
    }

    private boolean checkPermission() throws Exception {
        String path = this.poll_.getParentPath();
        if (path.indexOf(PollNodeTypes.APPLICATION_DATA) > 0) {
            String group = path.substring(path.indexOf("/", 3), path.indexOf(PollNodeTypes.APPLICATION_DATA) - 1);
            this.hasPermission = this.hasUserInGroup(group, this.userId);
        } else {
            this.hasPermission = true;
        }
        return this.hasPermission;
    }

    public void updateFormPoll(Poll poll) throws Exception {
        if (poll.getIsClosed()) {
            poll.setExpire(Utils.getExpire((long)-1L, (Date)poll.getModifiedDate(), (String[])this.dateUnit));
        } else {
            poll.setExpire(Utils.getExpire((long)poll.getTimeOut(), (Date)poll.getModifiedDate(), (String[])this.dateUnit));
        }
        this.poll_ = poll;
        this.isEditPoll = false;
        this.checkPermission();
    }

    public void updatePollById(String pollId) throws Exception {
        this.pollId = pollId;
        this.isEditPoll = true;
    }

    private void removeChilren() {
        List children = this.getChildren();
        ArrayList<String> childrenIds = new ArrayList<String>(children.size());
        for (UIComponent child : children) {
            if (!(child instanceof UIPollRadioBoxInput) && !(child instanceof UIForumCheckBoxInput)) continue;
            childrenIds.add(child.getId());
        }
        for (String childId : childrenIds) {
            this.removeChildById(childId);
        }
    }

    private void init() throws Exception {
        this.removeChilren();
        if (this.poll_ != null) {
            if (!this.poll_.getIsMultiCheck()) {
                ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
                for (int i = 0; i < this.poll_.getOption().length; ++i) {
                    options.add(new SelectItemOption(this.poll_.getOption()[i], (Object)this.getOptionId(POLL_OPTION_VALUE, i)));
                }
                UIPollRadioBoxInput input = new UIPollRadioBoxInput("option", "option", options);
                input.setAlign(1);
                this.addUIFormInput((UIFormInput)input);
            } else {
                String[] options = this.poll_.getOption();
                for (int i = 0; i < options.length; ++i) {
                    UIForumCheckBoxInput checkBoxInput = new UIForumCheckBoxInput(this.getOptionId("option", i), this.getOptionId("option", i), options[i], Boolean.valueOf(false));
                    this.addUIFormInput((UIFormInput)checkBoxInput.setInTable(true));
                }
            }
        }
    }

    private String getOptionId(String prefix, int index) {
        return new StringBuffer(prefix).append(index).toString();
    }

    private Poll getPoll() throws Exception {
        if (this.isEditPoll || this.poll_ == null) {
            this.poll_ = this.getPollService().getPoll(this.pollId);
            if (this.poll_ != null) {
                this.checkPermission();
                if (this.poll_.getIsClosed()) {
                    this.poll_.setExpire(Utils.getExpire((long)-1L, (Date)this.poll_.getModifiedDate(), (String[])this.dateUnit));
                } else {
                    this.poll_.setExpire(Utils.getExpire((long)this.poll_.getTimeOut(), (Date)this.poll_.getModifiedDate(), (String[])this.dateUnit));
                }
            } else {
                this.hasPermission = false;
            }
        }
        this.init();
        return this.poll_;
    }

    protected boolean getIsEditPoll() {
        return this.isEditPoll;
    }

    public void setEditPoll(boolean isEditPoll) {
        this.isEditPoll = isEditPoll;
    }

    protected boolean getCanViewEditMenu() {
        return this.isAdmin;
    }

    protected boolean isGuestPermission() throws Exception {
        String[] userVotes;
        Date today;
        if (this.poll_.getIsClosed()) {
            return true;
        }
        if (Utils.isEmpty((String)this.userId)) {
            return true;
        }
        if (this.poll_.getTimeOut() > 0L && (today = new Date()).getTime() - this.poll_.getCreatedDate().getTime() >= this.poll_.getTimeOut() * 86400000L) {
            return true;
        }
        if (this.isAgainVote) {
            return false;
        }
        for (String string : userVotes = this.poll_.getUserVote()) {
            if (!(string = string.substring(0, string.indexOf(org.exoplatform.poll.service.Utils.COLON))).equalsIgnoreCase(this.userId)) continue;
            return true;
        }
        return false;
    }

    protected String[] getInfoVote() throws Exception {
        long size;
        Poll poll = this.poll_;
        String[] voteNumber = poll.getVote();
        String[] userVotes = poll.getUserVote();
        long temp = size = (long)userVotes.length;
        if (size == 0L) {
            size = 1L;
        }
        int l = voteNumber.length;
        String[] infoVote = new String[l + 1];
        for (int j = 0; j < l; ++j) {
            String string = voteNumber[j];
            double tmp = Double.parseDouble(string);
            double k = tmp * (double)size / 100.0;
            int t = (int)Math.round(k);
            string = String.valueOf((double)t * 100.0 / (double)size);
            infoVote[j] = string + org.exoplatform.poll.service.Utils.COLON + String.valueOf(t);
        }
        infoVote[l] = String.valueOf(temp);
        return infoVote;
    }

    static /* synthetic */ Poll access$002(UIPoll x0, Poll x1) {
        x0.poll_ = x1;
        return x0.poll_;
    }

    static /* synthetic */ String access$100(UIPoll x0) {
        return x0.pollId;
    }

    static /* synthetic */ Poll access$000(UIPoll x0) {
        return x0.poll_;
    }

    static /* synthetic */ String access$200(UIPoll x0) {
        return x0.userId;
    }

    static /* synthetic */ void access$300(UIPoll x0, String x1, boolean x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ void access$400(UIPoll x0, String x1, boolean x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ boolean access$502(UIPoll x0, boolean x1) {
        x0.isAgainVote = x1;
        return x0.isAgainVote;
    }

    static /* synthetic */ boolean access$602(UIPoll x0, boolean x1) {
        x0.isEditPoll = x1;
        return x0.isEditPoll;
    }

    static /* synthetic */ Poll access$700(UIPoll x0) throws Exception {
        return x0.getPoll();
    }

    static /* synthetic */ void access$800(UIPoll x0) {
        x0.removeChilren();
    }
}

