/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.poll.webui.popup;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.webui.UIFormMultiValueInputSet;
import org.exoplatform.forum.common.webui.UISelector;
import org.exoplatform.poll.Utils;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollNodeTypes;
import org.exoplatform.poll.service.PollService;
import org.exoplatform.poll.webui.BasePollForm;
import org.exoplatform.poll.webui.popup.UIPollForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PositiveNumberFormatValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/poll/webui/popup/UIPollForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={RefreshActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIPollForm
extends BasePollForm
implements UIPopupComponent,
UISelector {
    public static final String FIELD_QUESTION_INPUT = "Question";
    public static final String FIELD_OPTIONS = "Option";
    public static final String FIELD_TIMEOUT_INPUT = "TimeOut";
    public static final String FIELD_GROUP_PRIVATE_INPUT = "GroupPrivate";
    public static final String FIELD_AGAINVOTE_CHECKBOX = "VoteAgain";
    public static final String FIELD_MULTIVOTE_CHECKBOX = "MultiVote";
    public static final String FIELD_PUBLIC_DATA_CHECKBOX = "PublicData";
    public static final String COLON = ":";
    public static final String DELETED = "deleted";
    public static final String ZERO = "0.0";
    public static final int MAX_TITLE = 100;
    private UIFormMultiValueInputSet uiFormMultiValue = new UIFormMultiValueInputSet("Option", "Option");
    private Poll poll = new Poll();
    private boolean isUpdate = false;
    public boolean isEditPath = true;
    private boolean isPublic = true;

    public UIPollForm() throws Exception {
        UIFormStringInput question = new UIFormStringInput(FIELD_QUESTION_INPUT, FIELD_QUESTION_INPUT, "");
        UIFormStringInput timeOut = new UIFormStringInput(FIELD_TIMEOUT_INPUT, FIELD_TIMEOUT_INPUT, "");
        timeOut.addValidator(PositiveNumberFormatValidator.class, new Object[0]);
        UICheckBoxInput VoteAgain = new UICheckBoxInput(FIELD_AGAINVOTE_CHECKBOX, FIELD_AGAINVOTE_CHECKBOX, Boolean.valueOf(false));
        UICheckBoxInput MultiVote = new UICheckBoxInput(FIELD_MULTIVOTE_CHECKBOX, FIELD_MULTIVOTE_CHECKBOX, Boolean.valueOf(false));
        UICheckBoxInput PublicData = new UICheckBoxInput(FIELD_PUBLIC_DATA_CHECKBOX, FIELD_PUBLIC_DATA_CHECKBOX, Boolean.valueOf(true));
        PublicData.setChecked(this.isPublic);
        UIFormStringInput GroupPrivate = new UIFormStringInput(FIELD_GROUP_PRIVATE_INPUT, FIELD_GROUP_PRIVATE_INPUT, "");
        GroupPrivate.setReadOnly(true);
        this.addUIFormInput((UIFormInput)question.addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)timeOut);
        this.addUIFormInput((UIFormInput)VoteAgain);
        this.addUIFormInput((UIFormInput)MultiVote);
        this.addUIFormInput((UIFormInput)PublicData);
        this.addUIFormInput((UIFormInput)GroupPrivate);
        this.setDefaulFall();
        this.setActions(new String[]{"Save", "Refresh", "Cancel"});
    }

    private void initMultiValuesField(List<String> list) throws Exception {
        if (this.uiFormMultiValue != null) {
            this.removeChildById(FIELD_OPTIONS);
        }
        this.uiFormMultiValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
        this.uiFormMultiValue.addValidator(MandatoryValidator.class, new Object[0]);
        this.uiFormMultiValue.setId(FIELD_OPTIONS);
        this.uiFormMultiValue.setName(FIELD_OPTIONS);
        this.uiFormMultiValue.setType(UIFormStringInput.class);
        this.uiFormMultiValue.setValue(list);
        this.addUIFormInput((UIFormInput)this.uiFormMultiValue);
    }

    protected String getDateAfter() throws Exception {
        Date date = new Date();
        if (this.poll != null && this.poll.getTimeOut() > 0L) {
            date = this.poll.getModifiedDate();
        }
        String format = "MM-dd-yyyy";
        return Utils.getFormatDate((String)format, (Date)date);
    }

    public void setUpdatePoll(Poll poll, boolean isUpdate) throws Exception {
        if (isUpdate) {
            this.poll = poll;
            this.getUIStringInput(FIELD_QUESTION_INPUT).setValue((Object)CommonUtils.decodeSpecialCharToHTMLnumber((String)poll.getQuestion()));
            this.getUIStringInput(FIELD_TIMEOUT_INPUT).setValue((Object)String.valueOf(poll.getTimeOut()));
            this.getUICheckBoxInput(FIELD_AGAINVOTE_CHECKBOX).setChecked(poll.getIsAgainVote());
            UICheckBoxInput multiVoteCheckInput = this.getUICheckBoxInput(FIELD_MULTIVOTE_CHECKBOX);
            multiVoteCheckInput.setChecked(poll.getIsMultiCheck());
            multiVoteCheckInput.setDisabled(true);
            String group = poll.getParentPath();
            poll.setOldParentPath(group);
            if (group.indexOf(PollNodeTypes.APPLICATION_DATA) > 0) {
                this.isPublic = false;
                this.getUICheckBoxInput(FIELD_PUBLIC_DATA_CHECKBOX).setChecked(this.isPublic);
                group = group.substring(group.indexOf("/", 2), group.indexOf(PollNodeTypes.APPLICATION_DATA) - 1);
                this.getUIStringInput(FIELD_GROUP_PRIVATE_INPUT).setValue((Object)group);
            } else if (group.indexOf(PollNodeTypes.POLLS) < 0) {
                this.isEditPath = false;
            }
            this.isUpdate = isUpdate;
            this.setDefaulFall();
        }
    }

    private void setDefaulFall() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isUpdate) {
            for (String string : this.poll.getOption()) {
                list.add(CommonUtils.decodeSpecialCharToHTMLnumber((String)string));
            }
        } else {
            list.add("");
            list.add("");
        }
        this.initMultiValuesField(list);
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public void updateSelect(String selectField, String value) throws Exception {
        this.getUIStringInput(selectField).setValue((Object)value);
        this.getUICheckBoxInput(FIELD_PUBLIC_DATA_CHECKBOX).setValue(Boolean.valueOf(false));
    }

    static /* synthetic */ void access$000(UIPollForm x0, String x1, String[] x2, boolean x3) {
        x0.warning(x1, x2, x3);
    }

    static /* synthetic */ UIFormMultiValueInputSet access$100(UIPollForm x0) {
        return x0.uiFormMultiValue;
    }

    static /* synthetic */ void access$200(UIPollForm x0, String x1, boolean x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ void access$300(UIPollForm x0, String x1, String[] x2, boolean x3) {
        x0.warning(x1, x2, x3);
    }

    static /* synthetic */ void access$400(UIPollForm x0, String x1, String[] x2, boolean x3) {
        x0.warning(x1, x2, x3);
    }

    static /* synthetic */ boolean access$500(UIPollForm x0) {
        return x0.isUpdate;
    }

    static /* synthetic */ Poll access$600(UIPollForm x0) {
        return x0.poll;
    }

    static /* synthetic */ PollService access$700(UIPollForm x0) {
        return x0.getPollService();
    }

    static /* synthetic */ PollService access$800(UIPollForm x0) {
        return x0.getPollService();
    }

    static /* synthetic */ void access$900(UIPollForm x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ boolean access$502(UIPollForm x0, boolean x1) {
        x0.isUpdate = x1;
        return x0.isUpdate;
    }

    static /* synthetic */ void access$1000(UIPollForm x0, String x1, boolean x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ void access$1100(UIPollForm x0, List x1) throws Exception {
        x0.initMultiValuesField(x1);
    }
}

