/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller;

import jakarta.servlet.http.Cookie;
import java.util.List;
import java.util.Map;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.invocation.EventInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.controller.ControllerContext;
import org.gatein.pc.controller.EventControllerContextSafeInvoker;
import org.gatein.pc.controller.EventPhaseContext;
import org.gatein.pc.controller.PortletController;
import org.gatein.pc.controller.RequestHandler;
import org.gatein.pc.controller.event.EventControllerContext;
import org.gatein.pc.controller.event.WindowEvent;
import org.gatein.pc.controller.request.PortletRequest;
import org.gatein.pc.controller.response.ControllerResponse;
import org.gatein.pc.controller.response.PageUpdateResponse;
import org.gatein.pc.controller.response.PortletResponse;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.controller.state.WindowNavigationalState;

class PortletRequestHandler
extends RequestHandler<PortletRequest> {
    private static final EventControllerContextSafeInvoker safeInvoker = new EventControllerContextSafeInvoker();

    public PortletRequestHandler(PortletController controller) {
        super(PortletRequest.class, controller);
    }

    @Override
    ControllerResponse processResponse(ControllerContext context, PortletRequest portletRequest, PortletInvocationResponse response) throws PortletInvokerException {
        PageNavigationalState pageNavigationalState = portletRequest.getPageNavigationalState();
        pageNavigationalState = pageNavigationalState == null ? new PageNavigationalState(true) : new PageNavigationalState(pageNavigationalState, true);
        ResponseProperties requestProperties = new ResponseProperties();
        if (response instanceof UpdateNavigationalStateResponse) {
            UpdateNavigationalStateResponse updateResponse = (UpdateNavigationalStateResponse)response;
            this.updateNavigationalState(context, portletRequest.getWindowId(), updateResponse, pageNavigationalState);
            ResponseProperties update = updateResponse.getProperties();
            if (update != null) {
                requestProperties.append(update);
            }
            EventControllerContext eventCC = context.getEventControllerContext();
            EventPhaseContext phaseContext = new EventPhaseContext(this.controller, context, log);
            for (UpdateNavigationalStateResponse.Event portletEvent : updateResponse.getEvents()) {
                if (phaseContext.push(new WindowEvent(portletEvent.getName(), portletEvent.getPayload(), portletRequest.getWindowId()))) continue;
                return new PageUpdateResponse(updateResponse, requestProperties, pageNavigationalState, 1);
            }
            while (phaseContext.hasNext()) {
                PortletInvocationResponse eventResponse;
                WindowEvent toConsumeEvent = phaseContext.next();
                int consumedEventThreshold = this.controller.getConsumedEventThreshold();
                if (consumedEventThreshold >= 0 && phaseContext.consumedEventSize + 1 > consumedEventThreshold) {
                    log.trace((Object)"Event distribution interrupted because the maximum number of consumed event is reached");
                    safeInvoker.eventDiscarded(eventCC, phaseContext, toConsumeEvent, 5);
                    return new PageUpdateResponse(updateResponse, requestProperties, pageNavigationalState, 1);
                }
                try {
                    eventResponse = this.deliverEvent(context, toConsumeEvent, pageNavigationalState, PortletRequestHandler.getCookies(requestProperties));
                }
                catch (Exception e) {
                    log.trace((Object)("Event delivery of " + String.valueOf(toConsumeEvent) + " failed"), (Throwable)e);
                    safeInvoker.eventFailed(eventCC, phaseContext, toConsumeEvent, e);
                    continue;
                }
                ++phaseContext.consumedEventSize;
                if (eventResponse instanceof UpdateNavigationalStateResponse) {
                    UpdateNavigationalStateResponse eventStateResponse = (UpdateNavigationalStateResponse)eventResponse;
                    this.updateNavigationalState(context, toConsumeEvent.getWindowId(), eventStateResponse, pageNavigationalState);
                    for (UpdateNavigationalStateResponse.Event portletEvent : eventStateResponse.getEvents()) {
                        WindowEvent toRouteEvent = new WindowEvent(portletEvent.getName(), portletEvent.getPayload(), toConsumeEvent.getWindowId());
                        if (phaseContext.push(toConsumeEvent, toRouteEvent)) continue;
                        return new PageUpdateResponse(updateResponse, requestProperties, pageNavigationalState, 1);
                    }
                    ResponseProperties updateProperties = eventStateResponse.getProperties();
                    if (updateProperties != null) {
                        requestProperties.append(updateProperties);
                    }
                }
                safeInvoker.eventConsumed(eventCC, phaseContext, toConsumeEvent, eventResponse);
            }
            return new PageUpdateResponse(updateResponse, requestProperties, pageNavigationalState, 0);
        }
        return new PortletResponse(response, 0);
    }

    private PortletInvocationResponse deliverEvent(ControllerContext context, WindowEvent event, PageNavigationalState pageNavigationalState, List<Cookie> requestCookies) throws PortletInvokerException {
        WindowNavigationalState windowNS = pageNavigationalState.getWindowNavigationalState(event.getWindowId());
        if (windowNS == null) {
            windowNS = new WindowNavigationalState();
        }
        Map<String, String[]> publicNS = context.getStateControllerContext().getPublicWindowNavigationalState(context, pageNavigationalState, event.getWindowId());
        PortletInvocationContext portletInvocationContext = context.createPortletInvocationContext(event.getWindowId(), pageNavigationalState);
        EventInvocation eventInvocation = new EventInvocation(portletInvocationContext);
        eventInvocation.setMode(windowNS.getMode());
        eventInvocation.setWindowState(windowNS.getWindowState());
        eventInvocation.setNavigationalState(windowNS.getPortletNavigationalState());
        eventInvocation.setPublicNavigationalState(publicNS);
        eventInvocation.setName(event.getName());
        eventInvocation.setPayload(event.getPayload());
        return context.invoke(event.getWindowId(), requestCookies, eventInvocation);
    }

    private void updateNavigationalState(ControllerContext context, String windowId, UpdateNavigationalStateResponse update, PageNavigationalState page) throws PortletInvokerException {
        WindowNavigationalState windowNS = page.getWindowNavigationalState(windowId);
        if (windowNS == null) {
            windowNS = new WindowNavigationalState();
        }
        Mode mode = windowNS.getMode();
        if (update.getMode() != null) {
            mode = update.getMode();
        }
        WindowState windowState = windowNS.getWindowState();
        if (update.getWindowState() != null) {
            windowState = update.getWindowState();
        }
        StateString portletNS = windowNS.getPortletNavigationalState();
        if (update.getNavigationalState() != null) {
            portletNS = update.getNavigationalState();
        }
        windowNS = new WindowNavigationalState(portletNS, mode, windowState);
        page.setWindowNavigationalState(windowId, windowNS);
        Map publicNS = update.getPublicNavigationalStateUpdates();
        if (publicNS != null) {
            context.getStateControllerContext().updatePublicNavigationalState(context, page, windowId, publicNS);
        }
    }

    private static List<Cookie> getCookies(ResponseProperties properties) {
        if (properties.getCookies() == null) {
            return null;
        }
        return properties.getCookies().stream().map(cookie -> {
            Cookie jakartaCookie = new Cookie(cookie.getName(), cookie.getValue());
            jakartaCookie.setDomain(cookie.getDomain());
            jakartaCookie.setHttpOnly(cookie.isHttpOnly());
            jakartaCookie.setMaxAge(cookie.getMaxAge());
            jakartaCookie.setPath(cookie.getPath());
            jakartaCookie.setSecure(cookie.getSecure());
            return jakartaCookie;
        }).toList();
    }
}

