/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller.impl.event;

import java.util.LinkedList;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.controller.EventPhaseContext;
import org.gatein.pc.controller.event.EventControllerContext;
import org.gatein.pc.controller.event.WindowEvent;

public class EventControllerContextImpl
implements EventControllerContext {
    private PortletInvoker invoker;

    public EventControllerContextImpl(PortletInvoker invoker) {
        this.invoker = invoker;
    }

    @Override
    public Iterable<WindowEvent> eventProduced(EventPhaseContext context, WindowEvent producedEvent, WindowEvent sourceEvent) {
        try {
            LinkedList<WindowEvent> toConsume = new LinkedList<WindowEvent>();
            for (Portlet portlet : this.invoker.getPortlets()) {
                PortletInfo portletInfo = portlet.getInfo();
                if (!portletInfo.getEventing().getConsumedEvents().containsKey(producedEvent.getName())) continue;
                WindowEvent distributedEvent = new WindowEvent(producedEvent.getName(), producedEvent.getPayload(), portlet.getContext().getId());
                toConsume.addLast(distributedEvent);
            }
            return toConsume;
        }
        catch (PortletInvokerException e) {
            System.out.println("e = " + e);
            return null;
        }
    }

    @Override
    public void eventConsumed(EventPhaseContext context, WindowEvent consumedEvent, PortletInvocationResponse consumerResponse) {
    }

    @Override
    public void eventFailed(EventPhaseContext context, WindowEvent failedEvent, Throwable throwable) {
    }

    @Override
    public void eventDiscarded(EventPhaseContext context, WindowEvent discardedEvent, int cause) {
    }
}

