/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.embed;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.gatein.pc.embed.Chunk;

class Segment
extends Chunk
implements Iterable<Segment> {
    final String value;
    final Map<String, String[]> parameters;
    Chunk next;

    Segment(String value) {
        this(value, (Chunk)null);
    }

    Segment(String value, Chunk next) {
        this(value, null, next);
    }

    Segment(String value, Map<String, String[]> parameters) {
        this(value, parameters, null);
    }

    Segment(String value, Map<String, String[]> parameters, Chunk next) {
        this.value = value;
        this.parameters = parameters;
        this.next = next;
    }

    int size() {
        return this.next instanceof Segment ? ((Segment)this.next).size() + 1 : 1;
    }

    @Override
    public Iterator<Segment> iterator() {
        return new Iterator<Segment>(){
            private Segment next;
            {
                this.next = Segment.this;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Segment next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Segment current = this.next;
                this.next = this.next.next instanceof Segment ? (Segment)this.next.next : null;
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    protected void writeTo(StringBuilder sb, String amp) {
        sb.append('/');
        Segment.encode(sb, this.value, SEGMENT_VALUE);
        if (this.parameters != null) {
            for (Map.Entry<String, String[]> parameter : this.parameters.entrySet()) {
                for (String value : parameter.getValue()) {
                    sb.append(';');
                    Segment.encode(sb, parameter.getKey(), MATRIX_PARAM_NAME);
                    sb.append('=');
                    Segment.encode(sb, value, MATRIX_PARAM_VALUE);
                }
            }
        }
        if (this.next != null) {
            this.next.writeTo(sb, amp);
        }
    }
}

