/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.embed;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.embed.EmbedPhase;
import org.gatein.pc.embed.Page;
import org.gatein.pc.embed.Window;
import org.gatein.pc.portlet.PortletInvokerInterceptor;
import org.gatein.pc.portlet.aspects.ConsumerCacheInterceptor;
import org.gatein.pc.portlet.aspects.PortletCustomizationInterceptor;
import org.gatein.pc.portlet.aspects.RequestAttributeConversationInterceptor;
import org.gatein.pc.portlet.aspects.SecureTransportInterceptor;
import org.gatein.pc.portlet.aspects.ValveInterceptor;
import org.gatein.pc.portlet.container.ContainerPortletDispatcher;
import org.gatein.pc.portlet.container.ContainerPortletInvoker;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObject;
import org.gatein.pc.portlet.container.managed.PortletApplicationRegistry;
import org.gatein.pc.portlet.impl.container.PortletApplicationLifeCycle;
import org.gatein.pc.portlet.impl.deployment.DeploymentException;
import org.gatein.pc.portlet.impl.deployment.PortletApplicationDeployer;
import org.gatein.pc.portlet.impl.deployment.PortletApplicationDeployment;
import org.gatein.pc.portlet.impl.state.StateConverterV0;
import org.gatein.pc.portlet.impl.state.StateManagementPolicyService;
import org.gatein.pc.portlet.impl.state.producer.PortletStatePersistenceManagerService;
import org.gatein.pc.portlet.state.StateConverter;
import org.gatein.pc.portlet.state.StateManagementPolicy;
import org.gatein.pc.portlet.state.producer.PortletStatePersistenceManager;
import org.gatein.pc.portlet.state.producer.ProducerPortletInvoker;

public class EmbedServlet
extends HttpServlet {
    static final int MAX_EVENT_COUNT = 100;
    private PortletApplicationDeployer deployer;
    private PortletInvoker invoker;

    public void init(ServletConfig config) throws ServletException {
        PortletApplicationDeployment deployment;
        super.init(config);
        ContainerPortletInvoker containerPortletInvoker = new ContainerPortletInvoker();
        PortletApplicationDeployer deployer = new PortletApplicationDeployer(containerPortletInvoker);
        PortletInvokerInterceptor consumerPortletInvoker = new PortletInvokerInterceptor();
        consumerPortletInvoker.append((PortletInvoker)new ConsumerCacheInterceptor()).append((PortletInvoker)new PortletCustomizationInterceptor()).append((PortletInvoker)new ProducerPortletInvoker((PortletStatePersistenceManager)new PortletStatePersistenceManagerService(), (StateManagementPolicy)new StateManagementPolicyService(true), (StateConverter)new StateConverterV0())).append((PortletInvoker)containerPortletInvoker).append((PortletInvoker)new ValveInterceptor((PortletApplicationRegistry)deployer)).append((PortletInvoker)new SecureTransportInterceptor()).append((PortletInvoker)new RequestAttributeConversationInterceptor()).append((PortletInvoker)new ContainerPortletDispatcher());
        this.deployer = deployer;
        this.invoker = consumerPortletInvoker;
        try {
            deployment = deployer.add(this.getServletContext());
        }
        catch (DeploymentException e) {
            throw new ServletException((Throwable)e);
        }
        if (deployment != null) {
            PortletApplicationLifeCycle lifeCycle = deployment.getPortletApplicationLifeCycle();
            this.checkLifeCycle((ManagedObject)lifeCycle);
            for (ManagedObject dependency : lifeCycle.getDependencies()) {
                this.checkLifeCycle(dependency);
            }
        }
    }

    private void checkLifeCycle(ManagedObject managed) throws ServletException {
        if (managed.getStatus() != LifeCycleStatus.STARTED) {
            throw new ServletException("Portlet application start failed", managed.getFailure());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>(req.getParameterMap());
        Page page = new Page(this.invoker, req.getRequestURI());
        Window notFound = null;
        for (Window window : page.windows.values()) {
            if (window.portlet != null) continue;
            notFound = window;
            break;
        }
        if (notFound != null) {
            resp.sendError(404, "Portlet " + notFound.name + " is not found");
        } else {
            String[] phaseParam = (String[])parameters.remove("javax.portlet.phase");
            EmbedPhase phase = phaseParam != null ? ("render".equalsIgnoreCase(phaseParam[0]) ? new EmbedPhase.Render(page, this.invoker, parameters, req, resp) : ("action".equalsIgnoreCase(phaseParam[0]) ? new EmbedPhase.Action(page, this.invoker, parameters, req, resp) : ("resource".equalsIgnoreCase(phaseParam[0]) ? new EmbedPhase.Resource(page, this.invoker, parameters, req, resp) : null))) : new EmbedPhase.Render(page, this.invoker, parameters, req, resp);
            if (phase == null) {
                throw new ServletException("Illegal phase value " + req.getParameter("javax.portlet.phase"));
            }
            ((EmbedPhase)phase).invoke();
        }
    }

    public void destroy() {
        if (this.deployer != null) {
            this.deployer.remove(this.getServletContext());
        }
    }
}

