/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.federation;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import junit.framework.TestCase;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.pc.api.NoSuchPortletException;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.PortletStatus;
import org.gatein.pc.api.info.MetaInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.federation.FederatedPortletInvoker;
import org.gatein.pc.federation.FederatingPortletInvoker;
import org.gatein.pc.federation.PortletInvokerResolver;
import org.gatein.pc.federation.impl.FederatingPortletInvokerService;
import org.gatein.pc.portlet.support.PortletInvokerSupport;
import org.gatein.pc.portlet.support.PortletSupport;
import org.gatein.pc.portlet.support.info.PortletInfoSupport;

public class FederatingPortletInvokerTestCase
extends TestCase {
    private static final PortletContext PORTLET = PortletContext.createPortletContext((String)"/webapp:portlet", (boolean)false);
    private static final String INVOKER_ID = "foo";
    private static final PortletContext LOCAL_PORTLET = PortletContext.createPortletContext((String)"/web:local", (boolean)false);
    private static final PortletContext REFERENCED_PORTLET = PortletContext.reference((String)"foo", (PortletContext)PORTLET);
    private static final PortletContext REFERENCED_LOCAL_PORTLET = PortletContext.reference((String)"local", (PortletContext)LOCAL_PORTLET);
    private FederatingPortletInvoker federatingInvoker;
    private FederatedPortletInvoker federatedInvoker;
    private PortletInvokerSupport federatedInvokerDelegate;
    private FederatedPortletInvoker localInvoker;
    private PortletInvokerSupport localInvokerDelegate;
    private Portlet portlet;
    private PortletContext portletContext;

    public void setUp() throws Exception {
        this.federatingInvoker = new FederatingPortletInvokerService();
        this.federatedInvokerDelegate = new PortletInvokerSupport();
        PortletInfoSupport fooInfo = new PortletInfoSupport();
        fooInfo.getMeta().setDisplayName("FooPortlet");
        this.portlet = this.federatedInvokerDelegate.addPortlet(PORTLET.getId(), fooInfo);
        this.portletContext = this.portlet.getContext();
        this.federatedInvoker = this.federatingInvoker.registerInvoker(INVOKER_ID, (PortletInvoker)this.federatedInvokerDelegate);
        FederatingPortletInvokerTestCase.assertNotNull((Object)this.federatedInvoker);
        FederatingPortletInvokerTestCase.assertEquals((String)INVOKER_ID, (String)this.federatedInvoker.getId());
        this.localInvokerDelegate = new PortletInvokerSupport();
        PortletInfoSupport localInfo = new PortletInfoSupport();
        localInfo.getMeta().setDisplayName("LocalPortlet");
        this.localInvokerDelegate.addPortlet(LOCAL_PORTLET.getId(), localInfo);
        this.localInvoker = this.federatingInvoker.registerInvoker("local", (PortletInvoker)this.localInvokerDelegate);
        FederatingPortletInvokerTestCase.assertNotNull((Object)this.localInvoker);
        FederatingPortletInvokerTestCase.assertEquals((String)"local", (String)this.localInvoker.getId());
    }

    public void tearDown() throws Exception {
        this.federatedInvoker = null;
        this.localInvoker = null;
        this.federatingInvoker = null;
        this.portlet = null;
        this.portletContext = null;
    }

    public void testGetPortlets() throws PortletInvokerException {
        Set portlets = this.federatingInvoker.getPortlets();
        FederatingPortletInvokerTestCase.assertNotNull((Object)portlets);
        FederatingPortletInvokerTestCase.assertEquals((int)2, (int)portlets.size());
        for (Portlet portlet : portlets) {
            PortletContext context = portlet.getContext();
            FederatingPortletInvokerTestCase.assertTrue((REFERENCED_PORTLET.getId().equals(context.getId()) || REFERENCED_LOCAL_PORTLET.getId().equals(context.getId()) ? 1 : 0) != 0);
        }
    }

    public void testGetStatus() throws PortletInvokerException {
        FederatingPortletInvokerTestCase.assertEquals((Object)PortletStatus.OFFERED, (Object)this.federatingInvoker.getStatus(REFERENCED_PORTLET));
        FederatingPortletInvokerTestCase.assertEquals((Object)PortletStatus.OFFERED, (Object)this.federatingInvoker.getStatus(REFERENCED_LOCAL_PORTLET));
        FederatingPortletInvokerTestCase.assertEquals((Object)PortletStatus.OFFERED, (Object)this.federatedInvoker.getStatus(REFERENCED_PORTLET));
        FederatingPortletInvokerTestCase.assertEquals((Object)PortletStatus.OFFERED, (Object)this.localInvoker.getStatus(REFERENCED_LOCAL_PORTLET));
    }

    public void testFederation() throws PortletInvokerException {
        Collection federateds = this.federatingInvoker.getFederatedInvokerIds();
        FederatingPortletInvokerTestCase.assertNotNull((Object)federateds);
        FederatingPortletInvokerTestCase.assertEquals((int)2, (int)federateds.size());
        FederatedPortletInvoker federated = this.federatingInvoker.getFederatedInvoker(INVOKER_ID);
        FederatingPortletInvokerTestCase.assertNotNull((Object)federated);
        FederatingPortletInvokerTestCase.assertEquals((String)INVOKER_ID, (String)federated.getId());
        FederatingPortletInvokerTestCase.assertEquals((Object)this.federatedInvoker, (Object)federated);
        FederatingPortletInvokerTestCase.assertEquals((Object)this.federatedInvokerDelegate, (Object)federated.getPortletInvoker());
        federated = this.federatingInvoker.getFederatedInvoker("local");
        FederatingPortletInvokerTestCase.assertNotNull((Object)federated);
        FederatingPortletInvokerTestCase.assertEquals((String)"local", (String)federated.getId());
        FederatingPortletInvokerTestCase.assertEquals((Object)this.localInvoker, (Object)federated);
        FederatingPortletInvokerTestCase.assertEquals((Object)this.localInvokerDelegate, (Object)federated.getPortletInvoker());
    }

    public void testInfo() throws PortletInvokerException {
        PortletInfo info = this.portlet.getInfo();
        FederatingPortletInvokerTestCase.assertNotNull((Object)info);
        MetaInfo metaInfo = info.getMeta();
        FederatingPortletInvokerTestCase.assertNotNull((Object)metaInfo);
        LocalizedString description = metaInfo.getMetaValue("display-name");
        FederatingPortletInvokerTestCase.assertNotNull((Object)description);
        FederatingPortletInvokerTestCase.assertEquals((Object)Locale.ENGLISH, (Object)description.getDefaultLocale());
        FederatingPortletInvokerTestCase.assertEquals((String)"FooPortlet", (String)description.getDefaultString());
    }

    public void testGetPortletNonFederatedContext() throws PortletInvokerException {
        try {
            this.federatingInvoker.getPortlet(this.portletContext);
            FederatingPortletInvokerTestCase.fail((String)"Non federated context shouldn't be resolved by federating service");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetPortletOnFederatedInvoker() throws PortletInvokerException {
        PortletContext federatedContext = PortletContext.createPortletContext((String)(this.federatedInvoker.getId() + "." + this.portletContext.getId()));
        Portlet samePortlet = this.federatedInvoker.getPortlet(federatedContext);
        FederatingPortletInvokerTestCase.assertNotNull((Object)samePortlet);
        FederatingPortletInvokerTestCase.assertEquals((Object)samePortlet.getContext(), (Object)federatedContext);
    }

    public void testGetLocalPortlets() throws PortletInvokerException {
        Set localPortlets = this.federatingInvoker.getLocalPortlets();
        FederatingPortletInvokerTestCase.assertEquals((int)1, (int)localPortlets.size());
        Portlet localPortlet = (Portlet)localPortlets.iterator().next();
        FederatingPortletInvokerTestCase.assertNotNull((Object)localPortlet);
        FederatingPortletInvokerTestCase.assertEquals((Object)REFERENCED_LOCAL_PORTLET, (Object)localPortlet.getContext());
    }

    public void testGetRemotePortlets() throws PortletInvokerException {
        Set portlets = this.federatingInvoker.getRemotePortlets();
        FederatingPortletInvokerTestCase.assertEquals((int)1, (int)portlets.size());
        Portlet portlet = (Portlet)portlets.iterator().next();
        FederatingPortletInvokerTestCase.assertNotNull((Object)portlet);
        FederatingPortletInvokerTestCase.assertEquals((Object)REFERENCED_PORTLET, (Object)portlet.getContext());
    }

    public void testDelegatedResolution() throws PortletInvokerException {
        final TestFederatedPortletInvoker remote = new TestFederatedPortletInvoker(this);
        PortletInfoSupport remoteInfo = new PortletInfoSupport();
        remoteInfo.getMeta().setDisplayName("RemotePortlet");
        PortletContext context = PortletContext.createPortletContext((String)"/app:RemotePortlet");
        PortletSupport portlet = remote.addPortlet(context.getId(), remoteInfo);
        String federatedId = "inexistent";
        FederatingPortletInvokerTestCase.assertNull((Object)this.federatingInvoker.getFederatedInvoker("inexistent"));
        this.federatingInvoker.setPortletInvokerResolver(new PortletInvokerResolver(){

            public FederatedPortletInvoker resolvePortletInvokerFor(String invokerId, FederatingPortletInvoker callingInvoker, String compoundPortletId) throws NoSuchPortletException {
                TestCase.assertEquals((Object)FederatingPortletInvokerTestCase.this.federatingInvoker, (Object)callingInvoker);
                return remote;
            }

            public boolean knows(String invokerId) {
                return "inexistent".equals(invokerId);
            }

            public Collection<String> getKnownInvokerIds() {
                return Collections.singletonList("inexistent");
            }
        });
        FederatingPortletInvokerTestCase.assertEquals((Object)portlet, (Object)this.federatingInvoker.getPortlet(PortletContext.createPortletContext((String)("inexistent." + context.getId()))));
        FederatingPortletInvokerTestCase.assertEquals((Object)portlet, (Object)this.federatingInvoker.getPortlet(PortletContext.reference((String)"inexistent", (PortletContext)context)));
    }

    private class TestFederatedPortletInvoker
    extends PortletInvokerSupport
    implements FederatedPortletInvoker {
        private TestFederatedPortletInvoker(FederatingPortletInvokerTestCase federatingPortletInvokerTestCase) {
        }

        public String getId() {
            return "inexistent";
        }

        public Portlet getPortlet(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
            String portletId = portletContext.getId();
            if (portletId.startsWith(this.getId() + ".")) {
                return super.getPortlet(PortletContext.createPortletContext((String)portletId.substring(portletId.indexOf(".") + 1)));
            }
            throw new NoSuchPortletException(portletId);
        }

        public PortletInvoker getPortletInvoker() {
            return null;
        }

        public boolean isActive() {
            return true;
        }
    }
}

