/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import junit.framework.TestCase;
import org.gatein.pc.portlet.impl.jsr168.ByteBuffer;
import org.gatein.pc.portlet.impl.jsr168.CharBuffer;

public class ContentBufferTestCase
extends TestCase {
    public void testResetChars() {
        CharBuffer buffer = new CharBuffer();
        PrintWriter writer = buffer.getWriter();
        writer.print("foo");
        buffer.reset();
        ContentBufferTestCase.assertEquals((String)"", (String)buffer.getChars());
    }

    public void testResetBytes() throws IOException {
        ByteBuffer buffer = new ByteBuffer();
        OutputStream out = buffer.getOutputStream();
        out.write("foo".getBytes("UTF8"));
        buffer.reset();
        ContentBufferTestCase.assertEquals((int)0, (int)buffer.getBytes().length);
    }

    public void testResetAfterCommit() {
        ByteBuffer buffer1 = new ByteBuffer();
        buffer1.commit();
        try {
            buffer1.reset();
            ContentBufferTestCase.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CharBuffer buffer2 = new CharBuffer();
        buffer2.commit();
        try {
            buffer2.reset();
            ContentBufferTestCase.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCommit() {
        ByteBuffer buffer1 = new ByteBuffer();
        ContentBufferTestCase.assertFalse((boolean)buffer1.isCommited());
        buffer1.commit();
        ContentBufferTestCase.assertTrue((boolean)buffer1.isCommited());
        CharBuffer buffer2 = new CharBuffer();
        ContentBufferTestCase.assertFalse((boolean)buffer2.isCommited());
        buffer2.commit();
        ContentBufferTestCase.assertTrue((boolean)buffer2.isCommited());
    }

    public void testWriteCharsAfterCommit() {
        CharBuffer buffer = new CharBuffer();
        buffer.commit();
        PrintWriter writer = buffer.getWriter();
        ContentBufferTestCase.assertNotNull((Object)writer);
        writer.print("foo");
        writer.close();
        ContentBufferTestCase.assertEquals((String)"foo", (String)buffer.getChars());
    }

    public void testWriteCharsAndCommit() {
        CharBuffer buffer = new CharBuffer();
        PrintWriter writer = buffer.getWriter();
        ContentBufferTestCase.assertNotNull((Object)writer);
        writer.print("foo");
        buffer.commit();
        writer.print("bar");
        writer.close();
        ContentBufferTestCase.assertEquals((String)"foobar", (String)buffer.getChars());
    }

    public void testWriteBytesAfterCommit() throws IOException {
        ByteBuffer buffer = new ByteBuffer();
        buffer.commit();
        OutputStream out = buffer.getOutputStream();
        ContentBufferTestCase.assertNotNull((Object)out);
        out.write("foo".getBytes("UTF8"));
        out.close();
        ContentBufferTestCase.assertTrue((boolean)Arrays.equals("foo".getBytes("UTF8"), buffer.getBytes()));
    }

    public void testWriteBytesAndCommit() throws IOException {
        ByteBuffer buffer = new ByteBuffer();
        buffer.commit();
        OutputStream out = buffer.getOutputStream();
        out.write("foo".getBytes("UTF8"));
        ContentBufferTestCase.assertNotNull((Object)out);
        out.write("bar".getBytes("UTF8"));
        out.close();
        ContentBufferTestCase.assertTrue((boolean)Arrays.equals("foobar".getBytes("UTF8"), buffer.getBytes()));
    }

    public void testFlushWriterDoesCommit() {
        CharBuffer buffer = new CharBuffer();
        PrintWriter writer = buffer.getWriter();
        writer.print("foo");
        writer.flush();
        ContentBufferTestCase.assertTrue((boolean)buffer.isCommited());
    }

    public void testCloseWriterDoesCommit() {
        CharBuffer buffer = new CharBuffer();
        PrintWriter writer = buffer.getWriter();
        writer.print("foo");
        writer.close();
        ContentBufferTestCase.assertTrue((boolean)buffer.isCommited());
    }

    public void testFlushStreamDoesCommit() throws IOException {
        ByteBuffer buffer = new ByteBuffer();
        OutputStream out = buffer.getOutputStream();
        out.write("foo".getBytes("UTF8"));
        out.flush();
        ContentBufferTestCase.assertTrue((boolean)buffer.isCommited());
    }

    public void testClosestreamDoesCommit() throws IOException {
        ByteBuffer buffer = new ByteBuffer();
        OutputStream out = buffer.getOutputStream();
        out.write("foo".getBytes("UTF8"));
        out.close();
        ContentBufferTestCase.assertTrue((boolean)buffer.isCommited());
    }
}

