/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.gatein.pc.api.info.NavigationInfo;
import org.gatein.pc.portlet.impl.jsr168.PortletParameterMap;
import org.gatein.pc.portlet.support.info.NavigationInfoSupport;
import org.gatein.pc.portlet.support.info.ParameterInfoSupport;

public class ParametersTestCase
extends TestCase {
    private NavigationInfoSupport navigation;
    private PortletParameterMap map;

    public void setUp() {
        this.navigation = new NavigationInfoSupport();
        this.map = new PortletParameterMap((NavigationInfo)this.navigation);
    }

    public void tearDown() {
        this.map = null;
        this.navigation = null;
    }

    public void testGetWithNullName() {
        try {
            this.map.getParameterValue(null);
            ParametersTestCase.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSet() {
        this.map.setParameterValue("a", "b");
        ParametersTestCase.assertEquals((String)this.map.getParameterValue("a"), (String)"b");
    }

    public void testSetWithNullName() {
        try {
            this.map.setParameterValue(null, "b");
            ParametersTestCase.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetWithNullValue() {
        try {
            this.map.setParameterValue("a", null);
            ParametersTestCase.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetValues() {
        this.map.setParameterValues("a", new String[]{"b", "c"});
        ParametersTestCase.assertTrue((boolean)Arrays.equals(this.map.getParameterValues("a"), new String[]{"b", "c"}));
        ParametersTestCase.assertEquals((String)this.map.getParameterValue("a"), (String)"b");
    }

    public void testSetValuesWithNullName() {
        try {
            this.map.setParameterValues(null, new String[]{"a"});
            ParametersTestCase.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetValuesWithNullValues() {
        try {
            this.map.setParameterValues("a", null);
            ParametersTestCase.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetValuesWithZeroLengthValues() {
        try {
            this.map.setParameterValues("a", new String[0]);
            ParametersTestCase.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetValuesWithOneNullValue() {
        try {
            this.map.setParameterValues("a", new String[]{"a", null});
            ParametersTestCase.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBlah() {
        this.navigation.addPublicParameter(new ParameterInfoSupport("foo", new QName("", "foo")));
        this.navigation.addPublicParameter(new ParameterInfoSupport("abc", new QName("", "abc")));
        this.map.setParameterValue("juu", "daa");
        this.map.setParameterValue("foo", "bar");
        this.map.removePublicParameterValue("abc");
        Map privateMap = this.map.getPrivateMapSnapshot();
        ParametersTestCase.assertEquals((int)1, (int)privateMap.size());
        ParametersTestCase.assertEquals(Arrays.asList("daa"), Arrays.asList((Object[])privateMap.get("juu")));
        ParametersTestCase.assertEquals(null, privateMap.get("abc"));
        Map publicMap = this.map.getPublicMapSnapshot();
        ParametersTestCase.assertEquals((int)2, (int)publicMap.size());
        ParametersTestCase.assertEquals(Arrays.asList("bar"), Arrays.asList((Object[])publicMap.get("foo")));
        ParametersTestCase.assertEquals(Collections.emptyList(), Arrays.asList((Object[])publicMap.get("abc")));
        Map combinedMap = this.map.getMap();
        ParametersTestCase.assertEquals((int)2, (int)combinedMap.size());
        ParametersTestCase.assertEquals(Arrays.asList("bar"), Arrays.asList((Object[])combinedMap.get("foo")));
        ParametersTestCase.assertEquals(Arrays.asList("daa"), Arrays.asList((Object[])combinedMap.get("juu")));
    }

    public Class[] buildExceptionClasses() {
        return new Class[]{NullPointerException.class, IllegalArgumentException.class, IllegalArgumentException.class, ClassCastException.class};
    }

    public Map[] buildInvalidMaps() {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("a", null);
        HashMap<String, String[]> map2 = new HashMap<String, String[]>();
        map2.put("a", new String[0]);
        HashMap<String, String[]> map3 = new HashMap<String, String[]>();
        map3.put("a", new String[]{null});
        HashMap<String, Object> map4 = new HashMap<String, Object>();
        map4.put("a", new Object());
        return new Map[]{map1, map2, map3, map4};
    }
}

