/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.test.portlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import junit.framework.TestCase;
import org.gatein.common.util.MapBuilder;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.ParametersStateString;
import org.gatein.pc.api.StateString;

public class StateStringTestCase
extends TestCase {
    public void testMarshalling() throws IOException {
        this.check((StateString)new OpaqueStateString("blah"));
        this.check((StateString)ParametersStateString.create());
        this.check(MapBuilder.hashMap((Object)"foo", (Object)new String[]{"bar"}).get());
        this.check(MapBuilder.hashMap((Object)"foo", (Object)new String[]{"foo_1"}).put((Object)"bar", (Object)new String[]{"bar_1", "bar_2"}).get());
    }

    private void check(Map<String, String[]> parameters) throws IOException {
        this.check((StateString)ParametersStateString.create(parameters));
    }

    private void check(StateString parameters) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        parameters.writeTo(out);
        out.close();
        byte[] bytes = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream in = new DataInputStream(bais);
        StateString copy = StateString.create((DataInputStream)in);
        StateStringTestCase.assertEquals((Object)parameters, (Object)copy);
    }
}

