/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.deployment;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.common.io.IOTools;
import org.gatein.pc.portlet.container.ContainerPortletInvoker;
import org.gatein.pc.portlet.container.PortletContainer;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObject;
import org.gatein.pc.portlet.container.managed.ManagedObjectEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectLifeCycleEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEvent;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventBroadcaster;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.container.managed.ManagedPortletApplication;
import org.gatein.pc.portlet.container.managed.PortletApplicationRegistry;
import org.gatein.pc.portlet.impl.container.PortletApplicationLifeCycle;
import org.gatein.pc.portlet.impl.container.PortletContainerLifeCycle;
import org.gatein.pc.portlet.impl.deployment.DeploymentException;
import org.gatein.pc.portlet.impl.deployment.PortletApplicationDeployment;
import org.gatein.pc.portlet.impl.deployment.staxnav.PortletApplicationMetaDataBuilder;
import org.gatein.pc.portlet.impl.metadata.PortletApplication10MetaData;
import org.gatein.pc.portlet.impl.metadata.PortletApplication20MetaData;

public class PortletApplicationDeployer
implements PortletApplicationRegistry {
    private PortletApplicationRegistry registry;
    protected final Log log = ExoLogger.getLogger(PortletApplicationDeployer.class);
    private Map<String, PortletApplicationDeployment> deploymentMap = new HashMap<String, PortletApplicationDeployment>();
    private final Map<String, PortletApplicationLifeCycle> applications = new HashMap<String, PortletApplicationLifeCycle>();
    private ContainerPortletInvoker containerPortletInvoker;
    private final ManagedObjectRegistryEventBroadcaster broadcaster;
    private boolean schemaValidated;
    private final ManagedObjectRegistryEventListener bridgeToInvoker = new ManagedObjectRegistryEventListener(){

        @Override
        public void onEvent(ManagedObjectRegistryEvent event) {
            ManagedObjectEvent managedObjectEvent;
            ManagedObject managedObject;
            if (event instanceof ManagedObjectEvent && (managedObject = (managedObjectEvent = (ManagedObjectEvent)event).getManagedObject()) instanceof PortletContainerLifeCycle) {
                PortletContainerLifeCycle portletContainerLifeCycle = (PortletContainerLifeCycle)managedObject;
                PortletContainer portletContainer = portletContainerLifeCycle.getPortletContainer();
                if (managedObjectEvent instanceof ManagedObjectLifeCycleEvent) {
                    ManagedObjectLifeCycleEvent lifeCycleEvent = (ManagedObjectLifeCycleEvent)managedObjectEvent;
                    LifeCycleStatus status = lifeCycleEvent.getStatus();
                    if (status == LifeCycleStatus.STARTED) {
                        PortletApplicationDeployer.this.containerPortletInvoker.addPortletContainer(portletContainer);
                    } else {
                        PortletApplicationDeployer.this.containerPortletInvoker.removePortletContainer(portletContainer);
                    }
                }
            }
        }
    };

    public PortletApplicationDeployer(ContainerPortletInvoker containerPortletInvoker) {
        this.broadcaster = new ManagedObjectRegistryEventBroadcaster();
        this.broadcaster.addListener(this.bridgeToInvoker);
        this.containerPortletInvoker = containerPortletInvoker;
    }

    public PortletApplicationDeployer() {
        this(null);
    }

    public boolean isSchemaValidated() {
        return this.schemaValidated;
    }

    public void setSchemaValidated(boolean schemaValidated) {
        this.schemaValidated = schemaValidated;
    }

    public ContainerPortletInvoker getContainerPortletInvoker() {
        return this.containerPortletInvoker;
    }

    public void setContainerPortletInvoker(ContainerPortletInvoker containerPortletInvoker) {
        this.containerPortletInvoker = containerPortletInvoker;
    }

    public final PortletApplicationDeployment add(ServletContext webApp) throws DeploymentException {
        PortletApplication10MetaData metaData = this.buildPortletApplicationMetaData(webApp);
        if (metaData != null) {
            PortletApplicationDeployment deployment = this.createPortletApplicationDeployment(webApp, metaData);
            this.deploymentMap.put(webApp.getContextPath(), deployment);
            deployment.install();
            PortletApplicationLifeCycle portletApplicationLifeCycle = deployment.getPortletApplicationLifeCycle();
            this.applications.put(portletApplicationLifeCycle.getId(), portletApplicationLifeCycle);
            return deployment;
        }
        return null;
    }

    public final void remove(ServletContext webApp) {
        PortletApplicationDeployment deployment = null;
        try {
            deployment = this.deploymentMap.remove(webApp.getContextPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (deployment != null) {
            PortletApplicationLifeCycle portletApplicationLifeCycle = deployment.getPortletApplicationLifeCycle();
            this.applications.remove(portletApplicationLifeCycle.getId());
            deployment.uninstall();
        }
    }

    protected PortletApplicationDeployment createPortletApplicationDeployment(ServletContext webApp, PortletApplication10MetaData metaData) {
        return new PortletApplicationDeployment(this.broadcaster, webApp, metaData);
    }

    protected PortletApplication10MetaData buildPortletApplicationMetaData(ServletContext webApp) throws DeploymentException {
        URL url;
        try {
            url = webApp.getResource("/WEB-INF/portlet.xml");
        }
        catch (MalformedURLException e) {
            throw new DeploymentException("Could not read portlet.xml deployment descriptor", e);
        }
        if (url != null) {
            BufferedInputStream in = null;
            try {
                in = IOTools.safeBufferedWrapper((InputStream)url.openStream());
                PortletApplicationMetaDataBuilder builder = new PortletApplicationMetaDataBuilder();
                builder.setSchemaValidation(this.schemaValidated);
                PortletApplication20MetaData portletApplication20MetaData = builder.build(in);
                return portletApplication20MetaData;
            }
            catch (Exception e) {
                if (e instanceof DeploymentException) {
                    throw new DeploymentException("Could not deploy " + String.valueOf(url) + ":" + e.getMessage(), e.getCause());
                }
                throw new DeploymentException("Unexpected exception with portlet.xml " + String.valueOf(url), e);
            }
            finally {
                IOTools.safeClose((Closeable)in);
            }
        }
        return null;
    }

    @Override
    public Collection<? extends ManagedPortletApplication> getManagedPortletApplications() {
        return this.applications.values();
    }

    @Override
    public ManagedPortletApplication getManagedPortletApplication(String id) {
        return this.applications.get(id);
    }

    @Override
    public void addListener(ManagedObjectRegistryEventListener listener) {
        this.broadcaster.addListener(listener);
    }

    @Override
    public void removeListener(ManagedObjectRegistryEventListener listener) {
        this.broadcaster.removeListener(listener);
    }
}

