/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.josso;

import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.agent.josso.GateInAuthenticationDelegate;
import org.josso.agent.SSOAgentRequest;

public abstract class GateInJOSSOAgentFactory {
    private static AtomicReference<GateInJOSSOAgentFactory> INSTANCE = new AtomicReference();
    private static final Logger log = LoggerFactory.getLogger(GateInJOSSOAgentFactory.class);

    public static GateInJOSSOAgentFactory getInstance() {
        GateInJOSSOAgentFactory result = INSTANCE.get();
        if (result == null) {
            INSTANCE.compareAndSet(null, GateInJOSSOAgentFactory.createInstance());
            result = INSTANCE.get();
        }
        return result;
    }

    private static GateInJOSSOAgentFactory createInstance() {
        try {
            Class<?> factoryClass = Thread.currentThread().getContextClassLoader().loadClass("org.gatein.sso.agent.josso.impl.GateInJOSSOAgentFactoryImpl");
            return (GateInJOSSOAgentFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract SSOAgentRequest getSSOAgentRequest(String var1, int var2, String var3, String var4, HttpServletRequest var5, HttpServletResponse var6);

    public abstract GateInAuthenticationDelegate getAuthenticationDelegate();
}

