/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.agent.filter.api.AbstractSSOInterceptor;
import org.gatein.sso.agent.opensso.OpenSSOAgent;
import org.gatein.wci.security.Credentials;

public class InitiateLoginFilter
extends AbstractSSOInterceptor {
    private static Logger log = LoggerFactory.getLogger(InitiateLoginFilter.class);
    private static final int DEFAULT_MAX_NUMBER_OF_LOGIN_ERRORS = 3;
    private String ssoServerUrl;
    private String ssoCookieName;
    private String loginUrl;
    private int maxNumberOfLoginErrors;
    private boolean attachUsernamePasswordToLoginURL;
    private OpenSSOAgent openSSOAgent;

    @Override
    protected void initImpl() {
        this.ssoServerUrl = this.getInitParameter("ssoServerUrl");
        this.ssoCookieName = this.getInitParameter("ssoCookieName");
        this.loginUrl = this.getInitParameter("loginUrl");
        String maxNumberOfLoginErrorsConfig = this.getInitParameter("maxNumberOfLoginErrors");
        this.maxNumberOfLoginErrors = maxNumberOfLoginErrorsConfig == null ? 3 : Integer.parseInt(maxNumberOfLoginErrorsConfig);
        String attachUsernamePasswordToLoginURLConfig = this.getInitParameter("attachUsernamePasswordToLoginURL");
        this.attachUsernamePasswordToLoginURL = attachUsernamePasswordToLoginURLConfig == null || Boolean.parseBoolean(attachUsernamePasswordToLoginURLConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            this.processSSOToken(req, resp);
            if (resp.isCommitted()) {
                return;
            }
            String portalContext = req.getContextPath();
            if (req.getAttribute("abort") != null) {
                String ssoSuffix = PropertyManager.getProperty((String)"gatein.sso.uri.suffix");
                if (StringUtils.isBlank((String)ssoSuffix)) {
                    ssoSuffix = "/sso";
                }
                String ssoRedirect = portalContext + (String)(ssoSuffix.startsWith("/") ? ssoSuffix : "/" + ssoSuffix);
                resp.sendRedirect(ssoRedirect);
                return;
            }
            String loginRedirectURL = this.getLoginRedirectUrl(req);
            if (StringUtils.isBlank((String)loginRedirectURL)) {
                log.warn((Object)"Can't redirect to null SSO URL");
                chain.doFilter(request, response);
            } else {
                loginRedirectURL = resp.encodeRedirectURL(loginRedirectURL);
                resp.sendRedirect(loginRedirectURL);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
    }

    protected OpenSSOAgent getOpenSSOAgent() {
        if (this.openSSOAgent == null) {
            OpenSSOAgent openssoAgent = (OpenSSOAgent)this.getExoContainer().getComponentInstanceOfType(OpenSSOAgent.class);
            if (openssoAgent == null) {
                throw new IllegalStateException("OpenSSOAgent component not provided in PortalContainer");
            }
            openssoAgent.setServerUrl(this.ssoServerUrl);
            openssoAgent.setCookieName(this.ssoCookieName);
            this.openSSOAgent = openssoAgent;
        }
        return this.openSSOAgent;
    }

    protected void processSSOToken(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        try {
            this.getOpenSSOAgent().validateTicket(httpRequest, httpResponse);
        }
        catch (IllegalStateException ilse) {
            int currentNumberOfErrors = this.getCountOfUnsuccessfulAttempts(httpRequest);
            log.warn((Object)("Count of login errors: " + currentNumberOfErrors));
            if (currentNumberOfErrors >= this.maxNumberOfLoginErrors) {
                log.warn((Object)"Max. number of login errors reached. Rethrowing exception");
                throw ilse;
            }
            httpRequest.setAttribute("abort", (Object)Boolean.TRUE);
        }
    }

    private int getCountOfUnsuccessfulAttempts(HttpServletRequest httpRequest) {
        Integer currentNumberOfErrors = (Integer)httpRequest.getSession().getAttribute("InitiateLoginFilter.currentNumberOfErrors");
        if (currentNumberOfErrors == null) {
            currentNumberOfErrors = 0;
        }
        currentNumberOfErrors = currentNumberOfErrors + 1;
        httpRequest.getSession().setAttribute("InitiateLoginFilter.currentNumberOfErrors", (Object)currentNumberOfErrors);
        return currentNumberOfErrors;
    }

    protected String getLoginRedirectUrl(HttpServletRequest req) {
        if (this.loginUrl == null) {
            return null;
        }
        StringBuilder url = new StringBuilder(this.loginUrl);
        if (this.attachUsernamePasswordToLoginURL) {
            String fakePassword = req.getSession().getId() + "_" + System.currentTimeMillis();
            Credentials creds = (Credentials)req.getSession().getAttribute("authenticatedCredentials");
            Object username = creds != null ? creds.getUsername() : fakePassword;
            url.append("?username=").append((String)username).append("&password=").append(fakePassword);
        }
        return url.toString();
    }
}

