/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.filter;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.sso.agent.filter.LoginRedirectFilter;

public class OpenSSOCDLoginRedirectFilter
extends LoginRedirectFilter {
    private static final Log log = ExoLogger.getLogger(OpenSSOCDLoginRedirectFilter.class);
    private String openSSORealm;
    private String agentUrl;
    private Random random = new Random();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", new Locale("en"));
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss", new Locale("en"));

    @Override
    public void initImpl() {
        super.initImpl();
        this.openSSORealm = this.getInitParameter("OpenSSORealm");
        this.agentUrl = this.getInitParameter("AgentUrl");
        log.info((Object)("Filter configuration: loginUrl=" + this.loginUrl + ", openSSORealm=" + this.openSSORealm + ", agentUrl=" + this.agentUrl));
    }

    @Override
    protected String getLoginRedirectURL(HttpServletRequest httpRequest) {
        try {
            StringBuilder urlBuilder = new StringBuilder(this.loginUrl);
            urlBuilder.append("?realm=").append(this.openSSORealm);
            urlBuilder.append("&goto=").append(URLEncoder.encode(this.agentUrl, "UTF-8"));
            String providerId = this.agentUrl + "/?Realm=" + URLEncoder.encode("/" + this.openSSORealm, "UTF-8");
            urlBuilder.append("&ProviderID=").append(URLEncoder.encode(providerId, "UTF-8"));
            int requestId = this.random.nextInt(100000) + 1;
            urlBuilder.append("&RequestID=").append(requestId);
            httpRequest.getSession().setAttribute("OpenSSOAgent.InResponseTo", (Object)requestId);
            String issueInstant = this.getFormattedDate();
            urlBuilder.append("&IssueInstant=" + URLEncoder.encode(issueInstant, "UTF-8"));
            urlBuilder.append("&MajorVersion=1&MinorVersion=0");
            String urlToRedirect = urlBuilder.toString();
            if (log.isTraceEnabled()) {
                log.trace((Object)("URL for redirection to CDCServlet: " + urlToRedirect));
            }
            return urlToRedirect;
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    private String getFormattedDate() {
        Date d = new Date();
        return this.dateFormat.format(d) + "T" + this.timeFormat.format(d) + "Z";
    }
}

