/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.sso.agent.filter.api.AbstractSSOInterceptor;

public class LoginRedirectFilter
extends AbstractSSOInterceptor {
    String loginUrl;
    private static final Log log = ExoLogger.getLogger(LoginRedirectFilter.class);

    @Override
    protected void initImpl() {
        this.loginUrl = this.getInitParameter("LOGIN_URL");
        log.info((Object)("Filter configuration: loginUrl=" + this.loginUrl));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String urlToRedirect = this.getLoginRedirectURL(httpRequest);
        urlToRedirect = httpResponse.encodeRedirectURL(urlToRedirect);
        httpResponse.sendRedirect(urlToRedirect);
    }

    protected String getLoginRedirectURL(HttpServletRequest httpRequest) {
        Object url = this.loginUrl;
        if (httpRequest.getQueryString() != null) {
            url = (String)url + "?" + httpRequest.getQueryString();
        }
        return url;
    }
}

