/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.login;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import javax.security.auth.login.LoginException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.services.security.jaas.AbstractLoginModule;
import org.gatein.sso.agent.tomcat.ServletAccess;
import org.gatein.wci.security.Credentials;

public final class SSOLoginModule
extends AbstractLoginModule {
    private static final Log log = ExoLogger.getLogger(SSOLoginModule.class);
    public static final String AUTHENTICATED_CREDENTIALS = "authenticatedCredentials";
    private static Method getContextMethod;

    public boolean login() throws LoginException {
        try {
            String username = null;
            HttpServletRequest request = this.getCurrentHttpServletRequest();
            if (request == null) {
                log.debug((Object)"HttpServletRequest is null. SSOLoginModule will be ignored.");
                return false;
            }
            Credentials credsFromSession = (Credentials)request.getSession().getAttribute(AUTHENTICATED_CREDENTIALS);
            if (credsFromSession != null) {
                username = credsFromSession.getUsername();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Found credentials in session. Username: " + username));
                }
            }
            if (username == null) {
                log.debug((Object)"SSOLogin Failed. Credential Not Found!!");
                return false;
            }
            Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
            if (authenticator == null) {
                throw new LoginException("No Authenticator component found, check your configuration");
            }
            Identity identity = authenticator.createIdentity(username);
            this.sharedState.put("exo.security.identity", identity);
            this.sharedState.put("javax.security.auth.login.name", username);
            this.subject.getPublicCredentials().add(new UsernameCredential(username));
            return true;
        }
        catch (Throwable e) {
            throw new LoginException(e.getMessage());
        }
    }

    public boolean logout() throws LoginException {
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean commit() throws LoginException {
        return true;
    }

    protected Log getLogger() {
        return log;
    }

    protected HttpServletRequest getCurrentHttpServletRequest() {
        HttpServletRequest request = null;
        if (getContextMethod != null) {
            try {
                request = (HttpServletRequest)getContextMethod.invoke(null, "jakarta.servlet.http.HttpServletRequest");
            }
            catch (Throwable e) {
                log.error((Object)"LoginModule error. Turn off session credentials checking with proper configuration option of LoginModule set to false");
                log.error((Object)this, e);
            }
        } else {
            request = ServletAccess.getRequest();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Returning HttpServletRequest " + request));
        }
        return request;
    }

    static {
        try {
            Class<?> policyContextClass = Thread.currentThread().getContextClassLoader().loadClass("javax.security.jacc.PolicyContext");
            getContextMethod = policyContextClass.getDeclaredMethod("getContext", String.class);
        }
        catch (ClassNotFoundException ignore) {
            log.debug((Object)"JACC not found ignoring it", (Throwable)ignore);
        }
        catch (Exception e) {
            log.error((Object)"Could not obtain JACC get context method", (Throwable)e);
        }
    }
}

